package com.ebmwebsourcing.easybox.impl;

import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

import org.w3c.dom.Node;

public class JaxbAddExtraInfoUnmarshallListener extends Unmarshaller.Listener {

    private final Binder<Node> binder;
    private final Map<JAXBElement<?>, AbstractJaxbModelObject> parentsByJAXBElement;

    public JaxbAddExtraInfoUnmarshallListener(Binder<Node> binder) {
        this.binder = binder;
        this.parentsByJAXBElement = new HashMap<JAXBElement<?>, AbstractJaxbModelObject>();
    }

    @Override
    public void beforeUnmarshal(Object target, Object parent) {
        AbstractJaxbModelObject ajoTarget = null;
        AbstractJaxbModelObject ajoParent = null;
        if (parent instanceof JAXBElement<?>) {
            ajoParent = (AbstractJaxbModelObject) parentsByJAXBElement
                    .get(((JAXBElement<?>) parent));
        } else {
            ajoParent = (AbstractJaxbModelObject) parent;
        }
        if (target instanceof JAXBElement<?>) {
            parentsByJAXBElement.put((JAXBElement<?>) target, ajoParent);
        } else {
            ajoTarget = (AbstractJaxbModelObject) target;
            ajoTarget.setBinder(binder);
            ajoTarget.setNaturalParent(ajoParent);
            if (parent instanceof JAXBElement<?>) {
                ajoTarget.setJaxbElement((JAXBElement<?>) parent);
            }
        }
    }

}
