package com.ebmwebsourcing.easybox.impl;

import java.net.URI;

import org.w3c.dom.Node;

import com.ebmwebsourcing.easybox.api.ModelObject;

public final class TextModelObject extends AbstractModelObject {

    private ModelObject parent;
	//private final String value;
    private String value;

	public TextModelObject(ModelObject parent, String value) {
	    //assert parent != null;
	    this.parent = parent;
	    this.value = value;
	}


	public Node getDOMNode() {
	    throw new AssertionError();
	};

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TextModelObject other = (TextModelObject) obj;
		return value.equals(other.value);
	}

	@Override
	public ModelObject getNaturalParent() {
	    return parent;
	}

	public ModelObject[] getChildren() {
	    return new ModelObject[0];
	}

	
	@Override
	public URI getBaseURI() {
		return parent.getBaseURI();
	}

	@Override
	public void setBaseURI(URI baseUri) {
	    throw new AssertionError();
	}

	
	@Override
	protected void setNaturalParent(ModelObject modelObject) {
	    this.parent = modelObject;
	}

	@Override
	public ModelObject duplicate() {
	    throw new AssertionError();
	}

	
    @Override
    public <X extends ModelObject> X duplicateAs(Class<X> targetClass) {
        throw new AssertionError();
    }
    
    String getValue() {
        return value;
    }
    
    void setValue(String value){
        this.value = value;
    }
    
    @Override
    public ModelObject getAdoptiveParent() {
        return null;
    }

    @Override
    protected void setAdoptiveParent(ModelObject modelObject) {
        throw new UnsupportedOperationException();
    }
}
