package com.ebmwebsourcing.easybox.impl;

import java.net.URI;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectAttribute;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;

final class XmlObjectAttributeImpl extends AbstractXmlObjectNodeImpl<AttributeModelObject> implements XmlObjectAttribute {


    XmlObjectAttributeImpl(XmlContext xmlContext, AttributeModelObject attributeModelObject) {
        super(xmlContext, attributeModelObject);
    }

    @Override
    public String getXmlObjectTextContent() {
        return String.valueOf(getXmlObjectValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        XmlObjectAttributeImpl other = (XmlObjectAttributeImpl) obj;
        if (getXmlObjectValue() == null) {
            if (other.getXmlObjectValue() != null)
                return false;
        } else if (!getXmlObjectValue().equals(other.getXmlObjectValue()))
            return false;
        return true;
    }

    @Override
    public XmlObjectNode[] getXmlObjectChildren() {
        return XmlObjectNode.EMPTY_ARRAY;
    }
    
    @Override
    public String toString() {
        return " '" + getXmlObjectValue() + "'";
    }

    @Override
    public Object getXmlObjectValue() {
        return getModelObject().getValue();
    }
    
    @Override
    public QName getXmlObjectQName() {
        return getModelObject().getQName();
    }
    
    @Override
    public URI getXmlObjectBaseURI() {
        return URI.create(getModelObject().getDOMNode().getBaseURI());
    }
    
    @Override
    protected AttributeModelObject createCompliantModel() {
        return new AttributeModelObject(null, new QName(""), "");
    }
}
