package com.ebmwebsourcing.easybox.impl;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.StringValue;

import com.ebmwebsourcing.easybox.api.XmlObjectText;

final class XmlObjectTextNodeInfo extends XmlObjectNodeNodeInfo {

    public XmlObjectTextNodeInfo(XmlObjectText xmlObjectText, Configuration configuration) {
        super(xmlObjectText, configuration);
    }

    XmlObjectText getXmlObjectText() {
        return (XmlObjectText) super.getXmlObjectNode();
    }

    
    @Override
    public final StringValue atomize() throws XPathException {
        return new StringValue(String.valueOf(getXmlObjectNode().getXmlObjectValue()));
    }
    
    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public int getNodeKind() {
        return Type.TEXT;
    }
    
    @Override
    public final SequenceIterator getTypedValue() throws XPathException {
        return atomize().getTypedValue();
    }

}
