package com.ebmwebsourcing.easybox.impl;

import java.util.List;

import com.ebmwebsourcing.easybox.api.XQueryException;
import com.ebmwebsourcing.easybox.api.XQueryValidationProfile;
import com.ebmwebsourcing.easybox.api.XQueryValidationReport;
import com.ebmwebsourcing.easybox.api.XQueryValidationRule;
import com.ebmwebsourcing.easybox.api.XQueryValidationRuleReport;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryEvaluator;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryValidator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.DefaultNamespaceContext;

final class XmlObjectXQueryValidatorImpl implements XmlObjectXQueryValidator {

//    private static Logger LOG = Logger.getLogger(XmlObjectXQueryValidatorImpl.class
//            .getName());
    

    private final XmlObjectXQueryEvaluator xqueryEvaluator;
    
    XmlObjectXQueryValidatorImpl(DefaultNamespaceContext namespaceContext) {
        xqueryEvaluator = new XmlObjectXQueryEvaluatorImpl(namespaceContext);
    }


    @Override
    public XQueryValidationReport validate(XmlObject xmlObject,
            XQueryValidationProfile xqueryValidationProfile) {
        XQueryValidationReport validationReport = new XQueryValidationReport();
        for (XQueryValidationRule rule : xqueryValidationProfile.getRules()) {
            try {
                List<?> result = xqueryEvaluator.evaluate(xmlObject, rule.getXQuery());
                // isOk is supposed to be the first item returned in result list.
                assert !result.isEmpty();
                boolean isOk = (Boolean) result.get(0);
                validationReport.addRuleReport(new XQueryValidationRuleReport(rule, isOk));
            } catch (XQueryException e) {
                throw new UncheckedException(e);
            }
        }
        return validationReport;
    }
}
