/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.impl.JaxbVisitor;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;

public final class JaxbFindByIdVisitor
implements JaxbVisitor {
    private final String searchedId;
    private Object foundObject;

    public JaxbFindByIdVisitor(String searchedId) {
        assert (searchedId != null);
        this.searchedId = searchedId;
        this.foundObject = null;
    }

    private final String getJaxbObjectIdIfAny(Object jaxbObject) {
        if (jaxbObject instanceof JAXBElement) {
            jaxbObject = ((JAXBElement)jaxbObject).getValue();
        }
        try {
            Method getIdMethod = jaxbObject.getClass().getMethod("getId", new Class[0]);
            if (getIdMethod == null) {
                return null;
            }
            return getIdMethod.invoke(jaxbObject, new Object[0]).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void visitJaxbObject(Object jaxbObject) {
        if (jaxbObject == null) {
            return;
        }
        String id = this.getJaxbObjectIdIfAny(jaxbObject);
        if (this.searchedId.equals(id)) {
            this.foundObject = jaxbObject;
        }
    }

    public Object getFoundObject() {
        return this.foundObject;
    }
}

