/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import static com.ebmwebsourcing.easybox.impl.NodeInfoHelper.*;

import java.util.Iterator;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Value;

import com.ebmwebsourcing.easybox.api.XmlObject;



final class XmlObjectDocumentInfo implements DocumentInfo {

    private final XmlObject rootXmlObject;
    private final Configuration configuration;
    
    public XmlObjectDocumentInfo(XmlObject rootXmlObject, Configuration configuration) {
        this.rootXmlObject = rootXmlObject;
        this.configuration = configuration;
    }
    
    @Override
    public Value atomize() throws XPathException {
        throw new Error("Not implemented yet.");
    }

    @Override
    public int compareOrder(NodeInfo arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public void copy(Receiver arg0, int arg1, boolean arg2, int arg3)
            throws XPathException {
        throw new Error("Not implemented yet.");
    }

    @Override
    public void generateId(FastStringBuffer arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public String getAttributeValue(int arg0) {
        return null;
    }

    @Override
    public String getBaseURI() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public int getColumnNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public Configuration getConfiguration() {
        return configuration;
    }

    @Override
    public int[] getDeclaredNamespaces(int[] arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public String getDisplayName() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public long getDocumentNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this;
    }

    @Override
    public int getFingerprint() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public int getLineNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public String getLocalPart() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public int getNameCode() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public NamePool getNamePool() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public int getNodeKind() {
        return Type.DOCUMENT;
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public String getPrefix() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public NodeInfo getRoot() {
        return null;
    }

    @Override
    public String getStringValue() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public String getSystemId() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public int getTypeAnnotation() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public String getURI() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public boolean hasChildNodes() {
        return rootXmlObject != null;
    }

    @Override
    public boolean isId() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public boolean isIdref() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public boolean isNilled() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        return iterateAxis(axisNumber, null);
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
        case Axis.ANCESTOR:
            return createEmptyAxisIterator();
        case Axis.ANCESTOR_OR_SELF:
            return createEmptyAxisIterator();
        case Axis.ATTRIBUTE:
            return createEmptyAxisIterator();
        case Axis.CHILD:
            return SingleNodeIterator.makeIterator(wrapXmlObjectAsNodeInfo(rootXmlObject, configuration));
        case Axis.DESCENDANT:
            return createDescendantIterator(rootXmlObject, nodeTest, configuration);
        case Axis.DESCENDANT_OR_SELF:
            return createDescendantOrSelfIterator(rootXmlObject, nodeTest, configuration);
        case Axis.FOLLOWING:
            throw new Error("Not implemented yet.");
        case Axis.FOLLOWING_SIBLING:
            throw new Error("Not implemented yet.");
        case Axis.NAMESPACE:
            throw new Error("Not implemented yet.");
        case Axis.PARENT:
            return createEmptyAxisIterator();
        case Axis.PRECEDING:
            return createEmptyAxisIterator();
        case Axis.PRECEDING_OR_ANCESTOR:
            return createEmptyAxisIterator();
        case Axis.PRECEDING_SIBLING:
            return createEmptyAxisIterator();
        case Axis.SELF:
            return createSingletonAxisIterator(this);
        default:
            return null;
        }
    }

    @Override
    public void setSystemId(String systemId) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public CharSequence getStringValueCS() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public SequenceIterator getTypedValue() throws XPathException {
        throw new Error("Not implemented yet.");
    }

    @Override
    public String[] getUnparsedEntity(String arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public NodeInfo selectID(String arg0, boolean arg1) {
        throw new Error("Not implemented yet.");
    }
    
    
}
