/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import static com.ebmwebsourcing.easybox.impl.NodeInfoHelper.*;

import java.net.URI;

import javax.xml.namespace.QName;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;

abstract class XmlObjectNodeNodeInfo implements NodeInfo {

    // TODO : / should return an XmlObjectDocument ; otherwise we cannot start expressions by //!
    
    private final XmlObjectNode xmlObjectNode;
    private final Configuration configuration;

    public XmlObjectNodeNodeInfo(XmlObjectNode xmlObjectNode, Configuration configuration) {
        this.xmlObjectNode = xmlObjectNode;
        this.configuration = configuration;
    }

    XmlObjectNode getXmlObjectNode() {
        return xmlObjectNode;
    }

    @Override
    public abstract Value atomize() throws XPathException;

    @Override
    public final int compareOrder(NodeInfo other) {
        assert other instanceof XmlObjectNodeNodeInfo;
        return this.getXmlObjectNode().compareTo(((XmlObjectNodeNodeInfo) other).getXmlObjectNode());
    }

    @Override
    public final void copy(Receiver arg0, int arg1, boolean arg2, int arg3) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final void generateId(FastStringBuffer arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getAttributeValue(int arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getBaseURI() {
        URI baseURI = xmlObjectNode.getXmlObjectBaseURI();
        return baseURI == null ? null : baseURI.toString(); 
    }

    @Override
    public final int getColumnNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final Configuration getConfiguration() {
        return configuration;
    }

    @Override
    public final int[] getDeclaredNamespaces(int[] arg0) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getDisplayName() {
        QName qname = xmlObjectNode.getXmlObjectQName();
        if (qname == null) return "";
        StringBuffer lexicalQName = new StringBuffer();
        if (qname.getPrefix() != null) {
            lexicalQName.append(qname.getPrefix()).append(":");
        }
        lexicalQName.append(qname.getLocalPart());
        return lexicalQName.toString();
    }

    @Override
    public final long getDocumentNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final DocumentInfo getDocumentRoot() {
        // TODO : 2 modes adoption mode, natural mode. 
        XmlObject xmlObjectBaseRoot = xmlObjectNode.getXmlObjectBaseRoot(); 
        return new XmlObjectDocumentInfo(xmlObjectBaseRoot, configuration);
    }

    @Override
    public final int getFingerprint() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final int getLineNumber() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getLocalPart() {
        return xmlObjectNode.getXmlObjectQName().getLocalPart();
    }

    @Override
    public final int getNameCode() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final NamePool getNamePool() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final NodeInfo getParent() {
    	XmlObject parent = xmlObjectNode.getXmlObjectParent();
    	if (parent == null) return null;
    	return new XmlObjectNodeInfo(parent, configuration);
    }

    @Override
    public final String getPrefix() {
        return xmlObjectNode.getXmlObjectQName().getPrefix();
    }

    @Override
    public final NodeInfo getRoot() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getStringValue() {
        return getXmlObjectNode().getXmlObjectTextContent();
    }

    @Override
    public final String getSystemId() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final int getTypeAnnotation() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final String getURI() {
        return xmlObjectNode.getXmlObjectQName().getNamespaceURI();
    }

    @Override
    public final boolean isId() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final boolean isIdref() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final boolean isNilled() {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final boolean isSameNodeInfo(NodeInfo other) {
        assert other instanceof XmlObjectNodeNodeInfo;
        return ((XmlObjectNodeNodeInfo) other).getXmlObjectNode() == getXmlObjectNode();
    }

    @Override
    public final AxisIterator iterateAxis(byte arg0) {
        return iterateAxis(arg0, null);
    }


    @Override
    public final AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return createAxisIterator(axisNumber, xmlObjectNode, nodeTest, configuration);
    }

    @Override
    public final void setSystemId(String systemId) {
        throw new Error("Not implemented yet.");
    }

    @Override
    public final CharSequence getStringValueCS() {
        return getStringValue();
    }

    @Override
    public abstract SequenceIterator getTypedValue() throws XPathException;

    @Override
    public final String toString() {
        return xmlObjectNode.toString(); 
    }
    
}
