/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

final class XmlObjectWriterImpl implements XmlObjectWriter {

    // TODO : be able to specify encoding !! (JAXB property to be set)
    
    private XmlContextImpl xmlContext;

    public XmlObjectWriterImpl(XmlContextImpl context) {
        this.xmlContext = context;
    }

    
    private Marshaller newMarshaller() {
        try {
            Marshaller marshaller = xmlContext.getJaxbContext().createMarshaller();
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", 
                        new JaxbNamespacePrefixMapperImpl(xmlContext));
            } catch( PropertyException e ) {
                throw new UncheckedException("Unrecognized JAXB property.", e);
            }

            return marshaller;
        } catch (JAXBException je) {
            throw new UncheckedException("Cannot create JAXB marshaller.", je);
        }
    } 
    
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public void writeDocument(XmlObject xmlObject, ContentHandler contentHandler)
            throws XmlObjectWriteException {
        assert xmlObject instanceof AbstractXmlObjectImpl<?>;
        assert xmlObject.getXmlObjectQName() != null;
        AbstractModelObject ajo = ((AbstractXmlObjectImpl<?>) xmlObject)
                .getModelObject();
        try {
            newMarshaller().marshal(
                    new JAXBElement(xmlObject.getXmlObjectQName(), ajo
                            .getClass(), ajo), contentHandler);
        } catch (JAXBException je) {
            throw new XmlObjectWriteException(je);
        }
    };
    
    @Override
    public void writeDocument(XmlObject xmlObject,
            java.io.OutputStream outputStream) throws XmlObjectWriteException {
        assert xmlObject instanceof AbstractXmlObjectImpl<?>;
        try {
            TransformerHandler serializer = ((SAXTransformerFactory) SAXTransformerFactory
                    .newInstance()).newTransformerHandler();
            serializer.setResult(new StreamResult(outputStream));
            writeDocument(xmlObject, serializer);
        } catch (TransformerConfigurationException e) {
            throw new UncheckedException(
                    "Cannot create transformer (TransformerConfigurationException)");
        } catch (TransformerFactoryConfigurationError e) {
            throw new UncheckedException(
                    "Cannot create transformer (TransformerFactoryConfigurationError)");
        }
    };

    
    @Override
    public void writeDocument(XmlObject xmlObject, Node node)
            throws XmlObjectWriteException {
        assert xmlObject instanceof AbstractXmlObjectImpl<?>;
        try {
            TransformerHandler serializer = ((SAXTransformerFactory) SAXTransformerFactory
                    .newInstance()).newTransformerHandler();
            serializer.setResult(new DOMResult(node));
            writeDocument(xmlObject, serializer);
        } catch (TransformerConfigurationException e) {
            throw new UncheckedException(
                    "Cannot create transformer (TransformerConfigurationException)");
        } catch (TransformerFactoryConfigurationError e) {
            throw new UncheckedException(
                    "Cannot create transformer (TransformerFactoryConfigurationError)");
        }    }
}
