/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import java.util.List;

import com.ebmwebsourcing.easybox.api.XQueryException;
import com.ebmwebsourcing.easybox.api.XQueryValidationProfile;
import com.ebmwebsourcing.easybox.api.XQueryValidationReport;
import com.ebmwebsourcing.easybox.api.XQueryValidationRule;
import com.ebmwebsourcing.easybox.api.XQueryValidationRuleReport;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryEvaluator;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryValidator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.DefaultNamespaceContext;

final class XmlObjectXQueryValidatorImpl implements XmlObjectXQueryValidator {

//    private static Logger LOG = Logger.getLogger(XmlObjectXQueryValidatorImpl.class
//            .getName());
    

    private final XmlObjectXQueryEvaluator xqueryEvaluator;
    
    XmlObjectXQueryValidatorImpl(DefaultNamespaceContext namespaceContext) {
        xqueryEvaluator = new XmlObjectXQueryEvaluatorImpl(namespaceContext);
    }


    @Override
    public XQueryValidationReport validate(XmlObject xmlObject,
            XQueryValidationProfile xqueryValidationProfile) {
        XQueryValidationReport validationReport = new XQueryValidationReport();
        for (XQueryValidationRule rule : xqueryValidationProfile.getRules()) {
            try {
                List<?> result = xqueryEvaluator.evaluate(xmlObject, rule.getXQuery());
                // isOk is supposed to be the first item returned in result list.
                assert !result.isEmpty();
                boolean isOk = (Boolean) result.get(0);
                validationReport.addRuleReport(new XQueryValidationRuleReport(rule, isOk));
            } catch (XQueryException e) {
                throw new UncheckedException(e);
            }
        }
        return validationReport;
    }
}
