/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.XmlObjectSchemaBinding;
import com.ebmwebsourcing.easybox.impl.ClassPathResourceResolver;
import easybox.testbinding0.impl.TestBinding0BindingImpl;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class ClassPathResourceResolverTest {
    private static final XmlObjectSchemaBinding TEST_BINDING = new TestBinding0BindingImpl();

    @Test
    public void testResolveExistingResourceByAbsoluteSystemId() {
        ClassPathResourceResolver cprr = new ClassPathResourceResolver();
        URL resolvedURL = cprr.resolveResourceBySystemId(TEST_BINDING.getOriginatingSchemaDir() + "/" + TEST_BINDING.getOriginatingSchemaName());
        Assert.assertTrue((boolean)(resolvedURL instanceof URL));
    }

    @Test
    public void testResolveExistingResourceByRelativeSystemId() {
        ClassPathResourceResolver cprr = new ClassPathResourceResolver();
        cprr.addOriginatingDir(TEST_BINDING.getOriginatingSchemaDir());
        URL resolvedURL = cprr.resolveResourceBySystemId(TEST_BINDING.getOriginatingSchemaName());
        Assert.assertTrue((boolean)(resolvedURL instanceof URL));
    }

    @Test
    public void testResolveNonExistingResourceBySystemId() {
        ClassPathResourceResolver cprr = new ClassPathResourceResolver();
        URL resolvedURL = cprr.resolveResourceBySystemId("this/resource/does/not/exist/in/classpath");
        Assert.assertNull((Object)resolvedURL);
    }

    @Test
    public void testResolveExistingResourceByNamespaceURI() {
        ClassPathResourceResolver cprr = new ClassPathResourceResolver();
        cprr.addOriginatingResourcePath(TEST_BINDING.getOriginatingSchemaNamespaceURI(), TEST_BINDING.getOriginatingSchemaDir() + "/" + TEST_BINDING.getOriginatingSchemaName());
        URL resolvedURL = cprr.resolveResourceByNamespaceURI(TEST_BINDING.getOriginatingSchemaNamespaceURI());
        Assert.assertTrue((boolean)(resolvedURL instanceof URL));
    }

    @Test
    public void testResolveNonExistingResourceByNamespaceURI() {
        ClassPathResourceResolver cprr = new ClassPathResourceResolver();
        URL resolvedURL = cprr.resolveResourceByNamespaceURI("http://this-namespace-URI-is-not-known");
        Assert.assertNull((Object)resolvedURL);
    }
}

