/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import javax.xml.namespace.QName;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

import com.ebmwebsourcing.easybox.api.XmlObjectAttribute;

final class XmlObjectAttributeNodeInfo extends XmlObjectNodeNodeInfo {


    public XmlObjectAttributeNodeInfo(XmlObjectAttribute xmlObjectAttribute, Configuration configuration) {
        super(xmlObjectAttribute, configuration);
    }


    @Override
    public final Value atomize() throws XPathException {
        Object value = getXmlObjectNode().getXmlObjectValue();
        if (value instanceof QName) {
            QName qname = (QName) value;
            return new QNameValue(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart()); 
        } else {
            // TODO implement other types!!!
            return new StringValue(String.valueOf(value));
        }
    }
    
    
    @Override
    XmlObjectAttribute getXmlObjectNode() {
        return (XmlObjectAttribute) super.getXmlObjectNode();
    }

    @Override
    public int getNodeKind() {
        return Type.ATTRIBUTE;
    }
    
    @Override
    public boolean hasChildNodes() {
        return false;
    }
    
    @Override
    public final SequenceIterator getTypedValue() throws XPathException {
        return atomize().iterate();
    }

}
