/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public final class XmlObjectDomBindingImpl implements XmlObjectBinding {

    @Override
    public String getName() {
        return "easybox-impl-dom";
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObjectNode>[] getFactorableClasses() {
        List<Class<? extends XmlObjectNode>> factorableClasses = new ArrayList<Class<? extends XmlObjectNode>>();
        factorableClasses.add(AnyXmlObjectImpl.class);    
        factorableClasses.add(XmlObjectTextImpl.class);    
        factorableClasses.add(XmlObjectAttributeImpl.class);    
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }

    @Override
    public boolean canWrap(Object obj) {
        return (obj instanceof DomModelObject) || (obj instanceof TextModelObject);
    }

    
    @SuppressWarnings("unchecked")
    @Override
    public <X extends XmlObjectNode> X wrap(XmlContext xmlContext,
            Class<X> xmlObjectImplClass, Object obj) {
        assert xmlObjectImplClass != null;
        assert xmlObjectImplClass.equals(AnyXmlObjectImpl.class) ||
               xmlObjectImplClass.equals(XmlObjectTextImpl.class);
        if (obj instanceof DomModelObject) {
            return (X) new AnyXmlObjectImpl(xmlContext, (DomModelObject) obj);
        } else if (obj instanceof TextModelObject) {
            return (X) new XmlObjectTextImpl(xmlContext, (TextModelObject) obj);
        } else {
            throw new UncheckedException(String.format(
                    "Do not know how to wrap object of class '%s'.", obj
            .getClass().getSimpleName()));
        }
    }

    @Override
    public XmlObjectNode wrap(XmlContext xmlContext, Object obj) {
        return wrap(xmlContext, AnyXmlObjectImpl.class, obj);
    }

    
    @SuppressWarnings("unchecked")
    @Override
    public <X extends XmlObjectNode> X create(XmlContext xmlContext,
            Class<X> xmlObjectImplClass) {
        assert xmlObjectImplClass != null;
        assert (xmlObjectImplClass == AnyXmlObjectImpl.class) ||
        (xmlObjectImplClass == XmlObjectTextImpl.class);
        if (xmlObjectImplClass == AnyXmlObjectImpl.class) {
            return (X) new AnyXmlObjectImpl(xmlContext, null);
        } else {
            return (X) new XmlObjectTextImpl(xmlContext, null);
        }
    }

    
    
    
}
