/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

import org.w3c.dom.Node;

public class JaxbAddExtraInfoUnmarshallListener extends Unmarshaller.Listener {

    private final Binder<Node> binder;
    private final Map<JAXBElement<?>, AbstractJaxbModelObject> parentsByJAXBElement;

    public JaxbAddExtraInfoUnmarshallListener(Binder<Node> binder) {
        this.binder = binder;
        this.parentsByJAXBElement = new HashMap<JAXBElement<?>, AbstractJaxbModelObject>();
    }

    @Override
    public void beforeUnmarshal(Object target, Object parent) {
        AbstractJaxbModelObject ajoTarget = null;
        AbstractJaxbModelObject ajoParent = null;
        if (parent instanceof JAXBElement<?>) {
            ajoParent = (AbstractJaxbModelObject) parentsByJAXBElement
                    .get(((JAXBElement<?>) parent));
        } else {
            ajoParent = (AbstractJaxbModelObject) parent;
        }
        if (target instanceof JAXBElement<?>) {
            parentsByJAXBElement.put((JAXBElement<?>) target, ajoParent);
        } else {
            ajoTarget = (AbstractJaxbModelObject) target;
            ajoTarget.setBinder(binder);
            ajoTarget.setNaturalParent(ajoParent);
            if (parent instanceof JAXBElement<?>) {
                ajoTarget.setJaxbElement((JAXBElement<?>) parent);
            }
        }
    }

}
