/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import java.net.URI;

import org.w3c.dom.Node;

import com.ebmwebsourcing.easybox.api.ModelObject;

public final class TextModelObject extends AbstractModelObject {

    private ModelObject parent;
	//private final String value;
    private String value;

	public TextModelObject(ModelObject parent, String value) {
	    //assert parent != null;
	    this.parent = parent;
	    this.value = value;
	}


	public Node getDOMNode() {
	    throw new AssertionError();
	};

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TextModelObject other = (TextModelObject) obj;
		return value.equals(other.value);
	}

	@Override
	public ModelObject getNaturalParent() {
	    return parent;
	}

	public ModelObject[] getChildren() {
	    return new ModelObject[0];
	}

	
	@Override
	public URI getBaseURI() {
		return parent.getBaseURI();
	}

	@Override
	public void setBaseURI(URI baseUri) {
	    throw new AssertionError();
	}

	
	@Override
	protected void setNaturalParent(ModelObject modelObject) {
	    this.parent = modelObject;
	}

	@Override
	public ModelObject duplicate() {
	    throw new AssertionError();
	}

	
    @Override
    public <X extends ModelObject> X duplicateAs(Class<X> targetClass) {
        throw new AssertionError();
    }
    
    String getValue() {
        return value;
    }
    
    void setValue(String value){
        this.value = value;
    }
    
    @Override
    public ModelObject getAdoptiveParent() {
        return null;
    }

    @Override
    protected void setAdoptiveParent(ModelObject modelObject) {
        throw new UnsupportedOperationException();
    }
}
