/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easybox.impl;

import java.net.URI;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectText;

final class XmlObjectTextImpl extends AbstractXmlObjectNodeImpl<TextModelObject> implements XmlObjectText {


    XmlObjectTextImpl(XmlContext xmlContext, TextModelObject textModelObject) {
        super(xmlContext, textModelObject);
    }

    @Override
    public String getXmlObjectTextContent() {
        return getXmlObjectValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        XmlObjectTextImpl other = (XmlObjectTextImpl) obj;
        if (getXmlObjectValue() == null) {
            if (other.getXmlObjectValue() != null)
                return false;
        } else if (!getXmlObjectValue().equals(other.getXmlObjectValue()))
            return false;
        return true;
    }

    @Override
    public XmlObjectNode[] getXmlObjectChildren() {
        return XmlObjectNode.EMPTY_ARRAY;
    }
    
    @Override
    public String toString() {
        return "\n# '" + getXmlObjectValue() + "'";
    }

    @Override
    public String getXmlObjectValue() {
        return getModelObject().getValue();
    }
    
    @Override
    public QName getXmlObjectQName() {
        return null;
    }
    
    @Override
    public URI getXmlObjectBaseURI() {
        return URI.create(getModelObject().getDOMNode().getBaseURI());
    }
    
    @Override
    protected TextModelObject createCompliantModel() {
        return new TextModelObject(null, "");
    }
    
    @Override
    public void setText(String text){
        getModelObject().setValue(text);
    }
    
}
