/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyplnk20.api.type;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easyplnk20.api.element.Role;
import com.ebmwebsourcing.easyplnk20.api.type.TPartnerLinkType;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public final class TPartnerLinkTypeTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_ROLES = "expectedRoles";

    public TPartnerLinkTypeTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetRoles() {
        TPartnerLinkType tPartnerLinkType = (TPartnerLinkType)this.newXmlObjectUnderTest();
        Object[] expectedRoles = (Role[])this.getTestData(EXPECTED_ROLES);
        Assert.assertArrayEquals((Object[])expectedRoles, (Object[])tPartnerLinkType.getRoles());
    }

    @Test
    public void testGetRoleByName() {
        Role[] expectedRoles;
        TPartnerLinkType tPartnerLinkType = (TPartnerLinkType)this.newXmlObjectUnderTest();
        for (Role expectedRole : expectedRoles = (Role[])this.getTestData(EXPECTED_ROLES)) {
            if (expectedRole.getName() == null) continue;
            Assert.assertEquals((Object)expectedRole, (Object)tPartnerLinkType.getRoleByName(expectedRole.getName()));
        }
    }

    @Test
    public void testAddRole() {
        TPartnerLinkType tPartnerLinkType = (TPartnerLinkType)this.newXmlObjectUnderTest();
        LinkedList<Role> expectedRoles = new LinkedList<Role>(Arrays.asList((Role[])this.getTestData(EXPECTED_ROLES)));
        Role newRole = (Role)this.getXmlContext().getXmlObjectFactory().create(Role.class);
        newRole.setName("newRoleName");
        expectedRoles.add(newRole);
        tPartnerLinkType.addRole(newRole);
        Assert.assertEquals(expectedRoles, Arrays.asList(tPartnerLinkType.getRoles()));
    }

    @Test
    public void testRemoveRole() {
        TPartnerLinkType tPartnerLinkType = (TPartnerLinkType)this.newXmlObjectUnderTest();
        for (Role e : tPartnerLinkType.getRoles()) {
            tPartnerLinkType.removeRole(e);
            Assert.assertFalse((boolean)Arrays.asList(tPartnerLinkType.getRoles()).contains(e));
        }
    }

    @Test
    public void testClearRoles() {
        TPartnerLinkType tPartnerLinkType = (TPartnerLinkType)this.newXmlObjectUnderTest();
        tPartnerLinkType.clearRoles();
        Assert.assertEquals((long)0L, (long)tPartnerLinkType.getRoles().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        TPartnerLinkType tPartnerLinkType = (TPartnerLinkType)this.newXmlObjectUnderTest();
        Role newRole = (Role)this.getXmlContext().getXmlObjectFactory().create(Role.class);
        tPartnerLinkType.addRole(newRole);
        Assert.assertEquals((Object)tPartnerLinkType, (Object)newRole.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        TPartnerLinkType tPartnerLinkType = (TPartnerLinkType)this.newXmlObjectUnderTest();
        Role newRole = (Role)this.getXmlContext().getXmlObjectFactory().create(Role.class);
        tPartnerLinkType.addRole(newRole);
        tPartnerLinkType.removeRole(newRole);
        Assert.assertNull((Object)newRole.getXmlObjectParent());
    }
}

