/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyplnk20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyplnk20.api.type.TRole;

import easybox.org.oasis_open.docs.wsbpel._2_0.plnktype.EJaxbTRole;

class TRoleImpl extends AbstractTExtensibleElementsImpl<EJaxbTRole> implements TRole {

    TRoleImpl(XmlContext xmlContext, EJaxbTRole modelObject) {
        super(xmlContext, modelObject);
    }

    @Override
    protected Class<? extends EJaxbTRole> getCompliantModelClass() {
        return EJaxbTRole.class;
    }


    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }


    @Override
    public boolean hasPortType() {
        return getModelObject().getPortType() != null;
    }

    @Override
    public QName getPortType() {
        return getModelObject().getPortType();
    }

    @Override
    public void setPortType(QName portType) {
        getModelObject().setPortType(portType);
    }
    
    
}
