/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyplnk20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyplnk20.api.element.Role;
import com.ebmwebsourcing.easyplnk20.api.type.TPartnerLinkType;

import easybox.org.oasis_open.docs.wsbpel._2_0.plnktype.EJaxbTPartnerLinkType;
import easybox.org.oasis_open.docs.wsbpel._2_0.plnktype.EJaxbTRole;

class TPartnerLinkTypeImpl extends AbstractTExtensibleElementsImpl<EJaxbTPartnerLinkType> implements TPartnerLinkType {

    TPartnerLinkTypeImpl(XmlContext xmlContext, EJaxbTPartnerLinkType modelObject) {
        super(xmlContext, modelObject);
    }

    @Override
    protected Class<? extends EJaxbTPartnerLinkType> getCompliantModelClass() {
        return EJaxbTPartnerLinkType.class;
    }


    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    
    @Override
    public Role[] getRoles() {
        return createChildrenArray(getModelObject().getRole(),
                EJaxbTRole.class, ANY_QNAME, Role.class);
    }

    @Override
    public Role getRoleByName(String name) {
        return getChildByName(getRoles(), name);
    }

    @Override
    public void addRole(Role role) {
        addToChildren(getModelObject().getRole(), role);        
    }

    @Override
    public void removeRole(Role role) {
        removeFromChildren(getModelObject().getRole(), role);
    }

    @Override
    public void clearRoles() {
        clearChildren(getModelObject().getRole(),
                EJaxbTRole.class, ANY_QNAME);
    }
    
    
}
