/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyplnk20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyplnk20.api.type.TRole;

import easybox.org.oasis_open.docs.wsbpel._2_0.plnktype.EJaxbTRole;

class TRoleImpl extends AbstractTExtensibleElementsImpl<EJaxbTRole> implements TRole {

    TRoleImpl(XmlContext xmlContext, EJaxbTRole modelObject) {
        super(xmlContext, modelObject);
    }

    @Override
    protected Class<? extends EJaxbTRole> getCompliantModelClass() {
        return EJaxbTRole.class;
    }


    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }


    @Override
    public boolean hasPortType() {
        return getModelObject().getPortType() != null;
    }

    @Override
    public QName getPortType() {
        return getModelObject().getPortType();
    }

    @Override
    public void setPortType(QName portType) {
        getModelObject().setPortType(portType);
    }
    
    
}
