/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyplnk20.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easyplnk20.api.Constants;

// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "easyplnk20-impl";
    }

    @Override
    public String getOriginatingSchemaDir() {
        return "schema/easyplnk20";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "easyplnk20.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.oasis_open.docs.wsbpel._2_0.plnktype.ObjectFactory.class
                .getPackage();
    }

    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.PLNK20_NS_URI;
    }

    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.PLNK20_NS_PREFERRED_PREFIX;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();

        // elements
        factorableClasses.add(PartnerLinkTypeImpl.class);
        factorableClasses.add(RoleImpl.class);

        // types
        factorableClasses.add(TRoleImpl.class);
        factorableClasses.add(TPartnerLinkTypeImpl.class);

        // anonymous types
        factorableClasses.add(DocumentationImpl.class);

        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }

    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject modelObject) throws InstantiationException,
            IllegalAccessException, InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, modelObject);
    }

}
