/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyvprop20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyvprop20.api.anonymoustype.PropertyAlias;
import com.ebmwebsourcing.easyvprop20.api.element.Query;

import easybox.org.oasis_open.docs.wsbpel._2_0.varprop.EJaxbPropertyAlias;

final class PropertyAliasImpl extends AbstractTExtensibleElementsImpl<EJaxbPropertyAlias> implements PropertyAlias {

    protected PropertyAliasImpl(XmlContext xmlContext, EJaxbPropertyAlias jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public boolean hasType() {
        return getModelObject().isSetType();
    }

    @Override
    public QName getType() {
        return getModelObject().getType();
    }

    @Override
    public void setType(QName qname) {
        getModelObject().setType(qname);
        
    }

    @Override
    public boolean hasElement() {
        return getModelObject().isSetElement();
    }

    @Override
    public QName getElement() {
        return getModelObject().getElement();
    }

    @Override
    public void setElement(QName element) {
        getModelObject().setElement(element);
    }

    @Override
    protected Class<? extends EJaxbPropertyAlias> getCompliantModelClass() {
        return EJaxbPropertyAlias.class;
    }

    @Override
    public boolean hasPropertyName() {
        return getModelObject().isSetPropertyName();
    }

    @Override
    public QName getPropertyName() {
        return getModelObject().getPropertyName();
    }

    @Override
    public void setPropertyName(QName propertyName) {
        getModelObject().setPropertyName(propertyName);
        
    }

    @Override
    public boolean hasMessageType() {
        return getModelObject().isSetMessageType();
    }

    @Override
    public QName getMessageType() {
        return getModelObject().getMessageType();
    }

    @Override
    public void setMessageType(QName messageType) {
        getModelObject().setMessageType(messageType);
        
    }

    @Override
    public boolean hasPart() {
        return getModelObject().isSetPart();
    }

    @Override
    public String getPart() {
        return getModelObject().getPart();
    }

    @Override
    public void setPart(String part) {
        getModelObject().setPart(part);
    }

    @Override
    public boolean hasQuery() {
        return getModelObject().isSetQuery();
    }

    @Override
    public Query getQuery() {
        if (getModelObject().getQuery() == null) return null;
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getQuery(), QueryImpl.class);
    }

    @Override
    public void setQuery(Query query) {
        if (query == null) {
            getModelObject().setQuery(null);
        } else {
            getModelObject().setQuery(((QueryImpl) query).getModelObject());
        }
    }

}
