/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyvprop20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyvprop20.api.anonymoustype.Property;

import easybox.org.oasis_open.docs.wsbpel._2_0.varprop.EJaxbProperty;

final class PropertyImpl extends AbstractTExtensibleElementsImpl<EJaxbProperty> implements Property {

    protected PropertyImpl(XmlContext xmlContext, EJaxbProperty jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
        
    }

    @Override
    public boolean hasType() {
        return getModelObject().isSetType();
    }

    @Override
    public QName getType() {
        return getModelObject().getType();
    }

    @Override
    public void setType(QName qname) {
        getModelObject().setType(qname);
        
    }

    @Override
    public boolean hasElement() {
        return getModelObject().isSetElement();
    }

    @Override
    public QName getElement() {
        return getModelObject().getElement();
    }

    @Override
    public void setElement(QName element) {
        getModelObject().setElement(element);
    }

    @Override
    protected Class<? extends EJaxbProperty> getCompliantModelClass() {
        return EJaxbProperty.class;
    }

}
