/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyvprop20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyvprop20.api.anonymoustype.PropertyAlias;
import com.ebmwebsourcing.easyvprop20.api.element.Query;

import easybox.org.oasis_open.docs.wsbpel._2_0.varprop.EJaxbPropertyAlias;

final class PropertyAliasImpl extends AbstractTExtensibleElementsImpl<EJaxbPropertyAlias> implements PropertyAlias {

    protected PropertyAliasImpl(XmlContext xmlContext, EJaxbPropertyAlias jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public boolean hasType() {
        return getModelObject().isSetType();
    }

    @Override
    public QName getType() {
        return getModelObject().getType();
    }

    @Override
    public void setType(QName qname) {
        getModelObject().setType(qname);
        
    }

    @Override
    public boolean hasElement() {
        return getModelObject().isSetElement();
    }

    @Override
    public QName getElement() {
        return getModelObject().getElement();
    }

    @Override
    public void setElement(QName element) {
        getModelObject().setElement(element);
    }

    @Override
    protected Class<? extends EJaxbPropertyAlias> getCompliantModelClass() {
        return EJaxbPropertyAlias.class;
    }

    @Override
    public boolean hasPropertyName() {
        return getModelObject().isSetPropertyName();
    }

    @Override
    public QName getPropertyName() {
        return getModelObject().getPropertyName();
    }

    @Override
    public void setPropertyName(QName propertyName) {
        getModelObject().setPropertyName(propertyName);
        
    }

    @Override
    public boolean hasMessageType() {
        return getModelObject().isSetMessageType();
    }

    @Override
    public QName getMessageType() {
        return getModelObject().getMessageType();
    }

    @Override
    public void setMessageType(QName messageType) {
        getModelObject().setMessageType(messageType);
        
    }

    @Override
    public boolean hasPart() {
        return getModelObject().isSetPart();
    }

    @Override
    public String getPart() {
        return getModelObject().getPart();
    }

    @Override
    public void setPart(String part) {
        getModelObject().setPart(part);
    }

    @Override
    public boolean hasQuery() {
        return getModelObject().isSetQuery();
    }

    @Override
    public Query getQuery() {
        if (getModelObject().getQuery() == null) return null;
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getQuery(), QueryImpl.class);
    }

    @Override
    public void setQuery(Query query) {
        if (query == null) {
            getModelObject().setQuery(null);
        } else {
            getModelObject().setQuery(((QueryImpl) query).getModelObject());
        }
    }

}
