/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easybpel.extended.activities.configure.impl;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XMLElement;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractXMLElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfiguration;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;

import easybpel.ebmwebsourcing.com.extendedactivityconfiguration.TExtendedActivityConfiguration;

public class ExtendedActivityConfigurationImpl extends AbstractXMLElementImpl<TExtendedActivityConfiguration> implements ExtendedActivityConfiguration {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Class<? extends ExtendedActivity> clazz = null;

	public ExtendedActivityConfigurationImpl(TExtendedActivityConfiguration model,
			XMLElement parent) {
		super(model, (AbstractXMLElementImpl) parent);
	}

	public String getClassName() {
		return this.model.getClassName();
	}

	public QName getTag() {
		return this.model.getTag();
	}

	public void addOtherElements(Element elmt) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	public Class<? extends ExtendedActivity> getExtendedActivityClass() throws ClassNotFoundException {
		this.clazz = (Class<? extends ExtendedActivity>) Thread.currentThread().getContextClassLoader().loadClass(this.getClassName());
		return this.clazz;
	}

}
