/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.extended.activities.configure.impl.inout;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityInitializationException;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityInitializationList;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.inout.ExtendedActivityInitializationListReader;
import com.ebmwebsourcing.easybpel.extended.activities.configure.impl.ExtendedActivityInitializationListImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.EasyNSFilter;

import easybpel.ebmwebsourcing.com.extendedactivityinitialization.TExtendedActivityInitializationList;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ExtendedActivityInitializationListReaderImpl implements ExtendedActivityInitializationListReader {


	private static Logger log = Logger.getLogger(ExtendedActivityInitializationListReaderImpl.class.getName());


	/*
	 * Private object initializations
	 */
	public ExtendedActivityInitializationListReaderImpl() throws ExtendedActivityInitializationException {
		ExtendedActivityInitializationJAXBContext.getInstance();
	}


	public ExtendedActivityInitializationListReaderImpl(final List<Class> addedObjectFactories) throws ExtendedActivityInitializationException {
		try {
			SchemaJAXBContext.getInstance().addOtherObjectFactory(addedObjectFactories);
		} catch (SchemaException e) {
			throw new ExtendedActivityInitializationException(e);
		}
		ExtendedActivityInitializationJAXBContext.getInstance();
	}
	
    
    public JAXBContext getJaxbContext() throws ExtendedActivityInitializationException {
    	return ExtendedActivityInitializationJAXBContext.getInstance().getJaxbContext();
    }


	private TExtendedActivityInitializationList convertStream2ExtendedActivityInitialization(final Source descriptorStream)
	throws ExtendedActivityInitializationException {

		try {
			final JAXBElement<TExtendedActivityInitializationList> wsdlBinding = this.getJaxbContext().createUnmarshaller()
			.unmarshal(descriptorStream, TExtendedActivityInitializationList.class);

			return wsdlBinding.getValue();

		} catch (final JAXBException e) {
			throw new ExtendedActivityInitializationException(
					"Failed to build Java bindings from descriptor XML document", e);
		}
	}



	public ExtendedActivityInitializationList read(final URI wsdlURI) throws ExtendedActivityInitializationException {
		ExtendedActivityInitializationList desc = null;
		try {
			InputStream input = null;

			final File f = new File(wsdlURI.toString());
			if (f.exists()) {
				input = new FileInputStream(f);
			} else {
				input = wsdlURI.toURL().openStream();
			}
			desc = this.read(wsdlURI, new InputSource(input));
		} catch (final MalformedURLException e) {
			throw new ExtendedActivityInitializationException("Can not get bpel at: " + wsdlURI, e);
		} catch (final IOException e) {
			throw new ExtendedActivityInitializationException("Can not get bpel at: " + wsdlURI, e);
		} catch (final IllegalArgumentException e) {
			throw new ExtendedActivityInitializationException("Can not get bpel at: " + wsdlURI, e);
		} 
		return desc;
	}

	public ExtendedActivityInitializationList read(final Document document) throws ExtendedActivityInitializationException {
		ExtendedActivityInitializationList desc = null;
		try {
			URI uri = null;
			if(document.getDocumentURI() != null) {
				uri = new URI(document.getDocumentURI());
			} else {
				uri = new File(".").toURI();
			}
			desc = this.read(uri,
					SourceHelper.convertDOMSource2InputSource(new DOMSource(document)));
		} catch (final URISyntaxException e) {
			throw new ExtendedActivityInitializationException(e);
		} catch (final XmlException e) {
			throw new ExtendedActivityInitializationException(e);
		}
		return desc;
	}

	public ExtendedActivityInitializationList read(final URI wsdlURI, final InputSource inputSource)
	throws ExtendedActivityInitializationException {
		ExtendedActivityInitializationList desc = null;
		try {
			
			log.finest("Loading " + wsdlURI);
			final XMLReader xmlReader = XMLReaderFactory.createXMLReader();
			final EasyNSFilter filter = new EasyNSFilter(xmlReader);
			final SAXSource saxSource = new SAXSource(filter, inputSource);
			
			final TExtendedActivityInitializationList def = this.convertStream2ExtendedActivityInitialization(saxSource);


			desc = new ExtendedActivityInitializationListImpl(def, null);
		} catch (final SAXException e) {
			throw new ExtendedActivityInitializationException(e);
		}
		return desc;
	}


	

}
