/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.extended.activities.configure.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XMLElement;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractXMLElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityInitializationException;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityInitialization;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityInitializationList;

import easybpel.ebmwebsourcing.com.extendedactivityinitialization.TExtendedActivityInitialization;
import easybpel.ebmwebsourcing.com.extendedactivityinitialization.TExtendedActivityInitializationList;

public class ExtendedActivityInitializationListImpl extends AbstractXMLElementImpl<TExtendedActivityInitializationList> implements ExtendedActivityInitializationList {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private List<ExtendedActivityInitialization> extendedActivitiesInits = new ArrayList<ExtendedActivityInitialization>();

	public ExtendedActivityInitializationListImpl(TExtendedActivityInitializationList model,
			XMLElement parent) throws ExtendedActivityInitializationException {
		super(model, (AbstractXMLElementImpl) parent);
		
		for(TExtendedActivityInitialization init: this.model.getExtendedActivityInitialization()) {
			this.extendedActivitiesInits.add(new ExtendedActivityInitializationImpl(init, this));
		}
	}


	public void addOtherElements(Element elmt) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}


	public List<ExtendedActivityInitialization> getExtendedActivityInitialization() {
		return this.extendedActivitiesInits;
	}





}
