/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.extended.activities.configure.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XMLElement;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractXMLElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfiguration;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationList;

import easybpel.ebmwebsourcing.com.extendedactivityconfiguration.TExtendedActivityConfiguration;
import easybpel.ebmwebsourcing.com.extendedactivityconfiguration.TExtendedActivityConfigurationList;

public class ExtendedActivityConfigurationListImpl extends AbstractXMLElementImpl<TExtendedActivityConfigurationList> implements ExtendedActivityConfigurationList {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private List<ExtendedActivityConfiguration> extendedActivitiesConfs = new ArrayList<ExtendedActivityConfiguration>();

	public ExtendedActivityConfigurationListImpl(TExtendedActivityConfigurationList model,
			XMLElement parent) {
		super(model, (AbstractXMLElementImpl) parent);
		
		for(TExtendedActivityConfiguration init: this.model.getExtendedActivityConf()) {
			this.extendedActivitiesConfs.add(new ExtendedActivityConfigurationImpl(init, this));
		}
	}

	public List<ExtendedActivityConfiguration> getExtendedActivityConf() {
		return this.extendedActivitiesConfs;
	}

	public void addOtherElements(Element elmt) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}





}
