/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.extended.activities.configure.impl;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XMLElement;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractXMLElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfiguration;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;

import easybpel.ebmwebsourcing.com.extendedactivityconfiguration.TExtendedActivityConfiguration;

public class ExtendedActivityConfigurationImpl extends AbstractXMLElementImpl<TExtendedActivityConfiguration> implements ExtendedActivityConfiguration {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Class<? extends ExtendedActivity> clazz = null;

	public ExtendedActivityConfigurationImpl(TExtendedActivityConfiguration model,
			XMLElement parent) {
		super(model, (AbstractXMLElementImpl) parent);
	}

	public String getClassName() {
		return this.model.getClassName();
	}

	public QName getTag() {
		return this.model.getTag();
	}

	public void addOtherElements(Element elmt) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	public Class<? extends ExtendedActivity> getExtendedActivityClass() throws ClassNotFoundException {
		this.clazz = (Class<? extends ExtendedActivity>) Thread.currentThread().getContextClassLoader().loadClass(this.getClassName());
		return this.clazz;
	}

}
