/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.api;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractXMLElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.AbstractValidatorManagerImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class BPELElementImpl<E> extends AbstractXMLElementImpl<E> implements BPELElement {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	protected QName tag = null;



	public BPELElementImpl(final QName tag, final E model, final BPELElement parent) {
		super(model, (BPELElementImpl) parent);
		this.tag = tag;
		this.validate();
	}
	
	public QName getTag() {
		return this.tag;
	}

	public void setTag(final QName name) {
		this.tag = name;
	}
	
	public void validate() {
		AbstractValidatorManagerImpl.getInstance().validate(this);
	}



	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}



	@Override
	public Documentation createDocumentation() {
		throw new NotImplementedException();
	}

	@Override
	public Documentation getDocumentation() {
		throw new NotImplementedException();
	}

	@Override
	public void setDocumentation(final Documentation arg0) {
		throw new NotImplementedException();
	}
	
	public void addOtherElements(final Element arg0) {
		throw new NotImplementedException();
	}
}
