/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easybpel.model.bpel.api.util;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;

import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.type.Form;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.marshalling.factory.MessageFactory;

public class MessageUtil {

    public static boolean createMessageIfNotExist(final Variable v,
            final Descriptions desc, final MessageFactory msgFactory)
            throws BPELException {
        boolean res = false;
        final BPELVariable definition = (BPELVariable) v;
        if ((v.getValue() == null) || (v.getValue().getContent() == null)) {
            final BPELInternalMessage message = MessageUtil.createMessage(
                    definition, desc, msgFactory);

            v.setValue(message);

            // set default value if exist
            if (definition.getFrom() != null) {
                // create literal element
                final Element rightSide = new Element("literal");
                final Document doc = new Document(rightSide);
                if (definition.getFrom().getKind() == From.Kind.EXPRESSION) {
                    final String value = definition.getFrom().getContent();
                    rightSide.setText(value);
                } else if (definition.getFrom().getKind() == From.Kind.LITERAL) {
                    // create literal element
                    if (definition.getFrom().getLiteral().getElementContent() != null) {
                        rightSide.addContent(definition.getFrom().getLiteral()
                                .getElementContent().detach());
                    } else if (definition.getFrom().getLiteral()
                            .getStringContent() != null) {
                        rightSide.setText(definition.getFrom().getLiteral()
                                .getStringContent());
                    }
                }
                // realize the affectation
                // 1 - Realize type verification
                // TODO: realize type verifcation

                // 2 - remove all child on left side
                ((Element) v.getValue().getContent()).removeContent();
                ((Element) v.getValue().getContent()).setText(null);

                // 3 - affect
                ((Element) v.getValue().getContent()).setText(rightSide
                        .getText());
            }
            res = true;
        }
        return res;
    }

    public static BPELInternalMessage createMessage(
            final BPELVariable variable, final Descriptions desc,
            final MessageFactory msgFactory) throws BPELException {
        BPELInternalMessage message = null;
        try {
            // Message not exist => Create message
            message = (BPELInternalMessage) msgFactory.createInternalMessage();

            if (variable.getMessageType() != null) {
                final Message msg = desc.findMessage(variable.getMessageType());
                if (msg == null) {
                    throw new BPELException(
                            "BPELError: the message cannot be null: "
                                    + variable.getMessageType());
                }

                // create all part
                final List<Element> elmts = new ArrayList<Element>();
                for (final Part part : msg.getParts()) {

                    // create part
                    if (part.getElement() != null) {
                        final com.ebmwebsourcing.easyschema10.api.element.Element elmt = part
                                .getElement();
                        final Element content = XSD2XML.newInstance()
                                .generateElement(
                                        elmt,
                                        part.getDescription().getModel(),
                                        null,
                                        SchemaHelper.findParentSchema(elmt)
                                                .getElementFormDefault(), 1,
                                        false, true);
                        elmts.add(content);
                    } else if (part.getType() != null) {
                        final com.ebmwebsourcing.easyschema10.api.element.Element elmt = part
                                .createElement();
                        elmt.setName(part.getQName().getLocalPart());
                        elmt.setType(part.getType());
                        final Element content = XSD2XML.newInstance()
                                .generateElement(elmt,
                                        part.getDescription().getModel(), null,
                                        Form.QUALIFIED, 1, false, true);
                        content.setNamespace(null);
                        elmts.add(content);
                    }
                }

                final Element rootMessage = new Element(variable
                        .getMessageType().getLocalPart());
                final Document doc = new Document(rootMessage);
                if (variable.getMessageType().getNamespaceURI() != null) {
                    rootMessage.setNamespace(Namespace.getNamespace(variable
                            .getMessageType().getPrefix(), variable
                            .getMessageType().getNamespaceURI()));
                }

                // add all parts
                for (final Element elmt : elmts) {

                    // test to avoid that a same prefix used by rootMessage and
                    // elmt have several namespaces
                    if (((rootMessage.getNamespacePrefix() != null) && (elmt
                            .getNamespace(rootMessage.getNamespacePrefix()) != null))
                            && (!elmt
                                    .getNamespace(
                                            rootMessage.getNamespacePrefix())
                                    .getURI()
                                    .equals(rootMessage.getNamespaceURI()))) {
                        // change root prefix
                        int i = 0;
                        Namespace nsAlreadyUsed = elmt.getNamespace("cns" + i);
                        while (nsAlreadyUsed != null) {
                            i++;
                            nsAlreadyUsed = elmt.getNamespace("cns" + i);
                        }
                        rootMessage.setNamespace(Namespace.getNamespace("cns"
                                + i, rootMessage.getNamespaceURI()));
                    }

                    rootMessage.addContent(elmt.detach());
                }

                message.setContent(doc.getRootElement());

                // print msg
            } else if (variable.getTypeQName() != null) {

                // create local variable
                com.ebmwebsourcing.easyschema10.api.type.Type type = SchemaHelper
                        .findTypeByQName(SchemaOfSchemas.getSchema(),
                                variable.getTypeQName());
                if (type == null) {
                    final List<com.ebmwebsourcing.easyschema10.api.type.Type> types = desc
                            .findTypesInAllSchema(variable.getTypeQName());
                    if (types.size() == 0) {
                        throw new BPELException("Impossible to find type \""
                                + variable.getTypeQName() + "\" in all schemas");
                    }
                    type = types.get(0);
                }

                if (type == null) {
                    throw new BPELException("Impossible to find type \""
                            + variable.getTypeQName() + "\" in all schemas");
                }

                XmlObjectFactory factory = type.getXmlContext()
                        .getXmlObjectFactory();
                final com.ebmwebsourcing.easyschema10.api.element.Schema schema = factory
                        .create(com.ebmwebsourcing.easyschema10.api.element.Schema.class);
                schema.setTargetNamespace(desc.getProcessNamespace());
                schema.setElementFormDefault(Form.QUALIFIED);
                schema.setAttributeFormDefault(Form.QUALIFIED);

                final com.ebmwebsourcing.easyschema10.api.element.Element elmt = factory
                        .create(com.ebmwebsourcing.easyschema10.api.element.Element.class);

                elmt.setName(variable.getQName().getLocalPart());
                elmt.setType(type.inferQName());
                schema.addElement(elmt);
                // TODO : this is should be done statically at compile time!!
                // otherwise this generates
                // unnecessary synchronization issues on addSchema and
                // getSchemas...
                desc.addSchema(schema);

                final Element jDomElmt = XSD2XML.newInstance().generateElement(
                        elmt, SchemaHelper.findParentSchema(type), null,
                        schema.getElementFormDefault(), 1, false, true);
                message.setContent(jDomElmt);

            } else {
                final List<com.ebmwebsourcing.easyschema10.api.element.Element> elmts = desc
                        .findElementsInAllSchema(variable.getElement());
                if ((elmts == null) || (elmts.size() == 0)) {
                    throw new BPELException("Impossible to find element");
                }

                final com.ebmwebsourcing.easyschema10.api.element.Element elmt = elmts
                        .get(0);
                Schema parentSchema = SchemaHelper.findParentSchema(elmt);
                final Element jDomElmt = XSD2XML.newInstance().generateElement(
                        elmt, parentSchema, null,
                        parentSchema.getElementFormDefault(), 1, false, true);
                message.setContent(jDomElmt);
            }
        } catch (CoreException e) {
            throw new BPELException(e);
        }
        return message;

    }
}
