/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.api.variable;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariables;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class BPELVariableImpl<T> extends BPELElementImpl<TVariable> implements BPELVariable<T> {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final TVariables variables;

	protected From from;
	
	private BPELInternalMessage msg;


	public BPELVariableImpl(final TVariable model, final TVariables variables, final BPELElement parent) {
		super(Constants._Variable_QNAME, model, parent);
		this.variables = variables;
	}

	public QName getElement() {
		return this.model.getElement();
	}


	public QName getMessageType() {
		return this.model.getMessageType();
	}


	public QName getQName() {
		QName res = null;
		if(this.model.getName() != null) {
			res = new QName(this.model.getName());
		}
		return res;
	}


	public QName getTypeQName() {
		return this.model.getType();
	}


	public void setElement(final QName elementName) {
		this.model.setElement(elementName);
	}


	public void setMessageType(final QName messageName) {
		this.model.setMessageType(messageName);
	}


	public void setQName(final QName name) {
		this.model.setName(name.getLocalPart());
	}


	public void setTypeQName(final QName type) {
		this.model.setType(type);
	}

	public QName getContent() {
		return new QName(this.model.getName());
	}


	public From getFrom() {
		return this.from;
	}

	public static String getVariableNameInXPathExpression(final String expression) {
		String res = null;
		String[] tokens = expression.split("\\.|/");
        if(tokens != null && tokens.length>0){
            return tokens[0].substring(tokens[0].indexOf("$")+1);
        }
		if(expression.indexOf(".") > 0) {
			res = expression.substring(expression.indexOf("$")+1, expression.indexOf("."));
		} else if(expression.indexOf("/") > 0) {
			res = expression.substring(expression.indexOf("$")+1, expression.indexOf("/"));
		} else {
			res = expression.substring(expression.indexOf("$")+1);
		}
		return res;
	}

	public static String getPartNameInXPathExpression(final String expression) {
		String res = null;
		if((expression.indexOf(".") > 0)&&(expression.indexOf("/") > 0)) {
			res = expression.substring(expression.indexOf(".")+1, expression.indexOf("/"));
		} else if(expression.indexOf(".") > 0) {
			res = expression.substring(expression.indexOf(".")+1);
		}
		return res;
	}

	public TVariables getVariables() {
		return this.variables;
	}

	public InternalMessage getValue() {
		return this.msg;
	}

	public void setValue(final InternalMessage value) {
		this.msg = (BPELInternalMessage) value;
	}

	public void setContent(final QName content) {
		this.model.setName(content.getLocalPart());
	}

}
