/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.api.util;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.FromAndTo;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.type.Form;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.marshalling.factory.MessageFactory;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;

public class MessageUtil {
    public static boolean createMessageIfNotExist(Variable v, Descriptions desc, MessageFactory msgFactory) throws BPELException {
        boolean res = false;
        BPELVariable definition = (BPELVariable)v;
        if (v.getValue() == null || v.getValue().getContent() == null) {
            BPELInternalMessage message = MessageUtil.createMessage(definition, desc, msgFactory);
            v.setValue((InternalMessage)message);
            if (definition.getFrom() != null) {
                Element rightSide = new Element("literal");
                Document doc = new Document(rightSide);
                if (definition.getFrom().getKind() == FromAndTo.Kind.EXPRESSION) {
                    String value = (String)definition.getFrom().getContent();
                    rightSide.setText(value);
                } else if (definition.getFrom().getKind() == FromAndTo.Kind.LITERAL) {
                    if (definition.getFrom().getLiteral().getElementContent() != null) {
                        rightSide.addContent(definition.getFrom().getLiteral().getElementContent().detach());
                    } else if (definition.getFrom().getLiteral().getStringContent() != null) {
                        rightSide.setText(definition.getFrom().getLiteral().getStringContent());
                    }
                }
                ((Element)v.getValue().getContent()).removeContent();
                ((Element)v.getValue().getContent()).setText(null);
                ((Element)v.getValue().getContent()).setText(rightSide.getText());
            }
            res = true;
        }
        return res;
    }

    public static BPELInternalMessage createMessage(BPELVariable variable, Descriptions desc, MessageFactory msgFactory) throws BPELException {
        BPELInternalMessage message = null;
        try {
            message = (BPELInternalMessage)msgFactory.createInternalMessage();
            if (variable.getMessageType() != null) {
                Message msg = desc.findMessage(variable.getMessageType());
                if (msg == null) {
                    throw new BPELException("BPELError: the message cannot be null: " + variable.getMessageType());
                }
                ArrayList<Element> elmts = new ArrayList<Element>();
                for (Part part : msg.getParts()) {
                    Element content;
                    com.ebmwebsourcing.easyschema10.api.element.Element elmt;
                    if (part.getElement() != null) {
                        elmt = part.getElement();
                        content = XSD2XML.newInstance().generateElement(elmt, part.getDescription().getModel(), null, SchemaHelper.findParentSchema((XmlObject)elmt).getElementFormDefault(), 1, false, true);
                        elmts.add(content);
                        continue;
                    }
                    if (part.getType() == null) continue;
                    elmt = part.createElement();
                    elmt.setName(part.getQName().getLocalPart());
                    elmt.setType(part.getType());
                    content = XSD2XML.newInstance().generateElement(elmt, part.getDescription().getModel(), null, Form.QUALIFIED, 1, false, true);
                    content.setNamespace(null);
                    elmts.add(content);
                }
                Element rootMessage = new Element(variable.getMessageType().getLocalPart());
                Document doc = new Document(rootMessage);
                if (variable.getMessageType().getNamespaceURI() != null) {
                    rootMessage.setNamespace(Namespace.getNamespace((String)variable.getMessageType().getPrefix(), (String)variable.getMessageType().getNamespaceURI()));
                }
                for (Element elmt : elmts) {
                    if (rootMessage.getNamespacePrefix() != null && elmt.getNamespace(rootMessage.getNamespacePrefix()) != null && !elmt.getNamespace(rootMessage.getNamespacePrefix()).getURI().equals(rootMessage.getNamespaceURI())) {
                        int i = 0;
                        Namespace nsAlreadyUsed = elmt.getNamespace("cns" + i);
                        while (nsAlreadyUsed != null) {
                            nsAlreadyUsed = elmt.getNamespace("cns" + ++i);
                        }
                        rootMessage.setNamespace(Namespace.getNamespace((String)("cns" + i), (String)rootMessage.getNamespaceURI()));
                    }
                    rootMessage.addContent(elmt.detach());
                }
                message.setContent(doc.getRootElement());
            } else if (variable.getTypeQName() != null) {
                Type type = SchemaHelper.findTypeByQName((XmlObject)SchemaOfSchemas.getSchema(), (QName)variable.getTypeQName());
                if (type == null) {
                    List<Type> types = desc.findTypesInAllSchema(variable.getTypeQName());
                    if (types.size() == 0) {
                        throw new BPELException("Impossible to find type \"" + variable.getTypeQName() + "\" in all schemas");
                    }
                    type = types.get(0);
                }
                if (type == null) {
                    throw new BPELException("Impossible to find type \"" + variable.getTypeQName() + "\" in all schemas");
                }
                XmlObjectFactory factory = type.getXmlContext().getXmlObjectFactory();
                Schema schema = (Schema)factory.create(Schema.class);
                schema.setTargetNamespace(desc.getProcessNamespace());
                schema.setElementFormDefault(Form.QUALIFIED);
                schema.setAttributeFormDefault(Form.QUALIFIED);
                com.ebmwebsourcing.easyschema10.api.element.Element elmt = (com.ebmwebsourcing.easyschema10.api.element.Element)factory.create(com.ebmwebsourcing.easyschema10.api.element.Element.class);
                elmt.setName(variable.getQName().getLocalPart());
                elmt.setType(type.inferQName());
                schema.addElement(elmt);
                desc.addSchema(schema);
                Element jDomElmt = XSD2XML.newInstance().generateElement(elmt, (XmlObject)SchemaHelper.findParentSchema((XmlObject)type), null, schema.getElementFormDefault(), 1, false, true);
                message.setContent(jDomElmt);
            } else {
                List<com.ebmwebsourcing.easyschema10.api.element.Element> elmts = desc.findElementsInAllSchema(variable.getElement());
                if (elmts == null || elmts.size() == 0) {
                    throw new BPELException("Impossible to find element");
                }
                com.ebmwebsourcing.easyschema10.api.element.Element elmt = elmts.get(0);
                Schema parentSchema = SchemaHelper.findParentSchema((XmlObject)elmt);
                Element jDomElmt = XSD2XML.newInstance().generateElement(elmt, (XmlObject)parentSchema, null, parentSchema.getElementFormDefault(), 1, false, true);
                message.setContent(jDomElmt);
            }
        }
        catch (CoreException e) {
            throw new BPELException(e);
        }
        return message;
    }
}

