/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.api;

import java.util.Map;
import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELWriter;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader.FeatureConstants;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.factory.AbstractFactoryImpl;
import com.ebmwebsourcing.easyviper.core.api.factory.Factory;

/**
 * This abstract class defines a factory API that enables applications to obtain
 * a BPELFactory capable of producing new Definitions, new WSDLReaders, and new
 * WSDLWriters.
 *
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class BPELFactory extends AbstractFactoryImpl implements Factory {
	
	public static String DEFAULT_NAME = "BpelEngine";


    /**
     * Create a new instance of a BPELReaderImpl.
     * @throws BPELException
     */
    public abstract BPELReader newBPELReader() throws BPELException;

    /**
     * Create a new instance of a BPELReaderImpl.
     * @throws BPELException
     */
    public abstract BPELReader newBPELReader(Map<FeatureConstants, Object> features) throws BPELException;

    /**
     * Create a new instance of a BPELWriterImpl.
     * @throws BPELException
     */
    public abstract BPELWriter newBPELWriter() throws BPELException;

    /**
     * Create the registry of process.
     * @throws BPELException
     */
    public abstract Core newBPELEngine(ConfigurationEngine cong, 
    		int numberOfReceivers, Class<? extends Receiver> receiverClass,
			int numberOfSenders, Class<? extends Sender> senderClass, Logger logger) throws BPELException;




}
