/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easybpel.model.bpel.api.util;

import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;

public class ScopeUtil {

	public static PartnerLink findPartnerLinkRecursively(final String name, final BPELElement parent) {
		PartnerLink res = null;
		final Scope parentScope = ScopeUtil.getParentScope(parent);
		if(parentScope != null) {
			res  = parentScope.findPartnerLink(name);
		}
		if(res == null) {
			final BPELProcess process = ScopeUtil.getProcess(parent);
			res = process.findPartnerLink(name); 
		}
		return res;
	}


	public static BPELProcess getProcess(final SchemaElement parent) {
		BPELProcess res = null;
		if(parent != null) {
			if(parent instanceof BPELProcess) {
				res = (BPELProcess) parent;
			} else {
				res = ScopeUtil.getProcess((BPELElement) ((AbstractSchemaElementImpl)parent).getParent());
			}
		}
		return res;
	}





	public static Scope getParentScope(final BPELElement child) {
		Scope res = null;
		if(child != null) {
			final BPELElement parent = (BPELElement) ((AbstractSchemaElementImpl)child).getParent();
			if(parent != null) {
				if(parent instanceof Scope) {
					res = (Scope) parent;
				} else {
					res = ScopeUtil.getParentScope(parent);
				}
			}
		}
		return res;
	}

}
