/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports;


import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.WSDLVersionConstants;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.PropertyAlias;
import org.petalslink.abslayer.service.api.Service;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class Descriptions {

    
    private static XmlContext xmlContext;
    
    
    static {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        xmlContext = xmlContextFactory.newContext();
    }
    
    String processNamespace;

    List<Import> imports = new ArrayList<Import>();
    List<Description> descriptions = new ArrayList<Description>();

    List<com.ebmwebsourcing.easyschema10.api.element.Schema> schemas = new ArrayList<com.ebmwebsourcing.easyschema10.api.element.Schema>();

    
    public Descriptions(final String processNamespace, final String processItfName, final List<Import> imports) {
        this.processNamespace = processNamespace;
        this.imports = imports;

        for(final Import impt: this.imports) {
			if(impt.getDescription() != null) {
				this.descriptions.add(impt.getDescription());
			} else if(impt.getSchema2() != null) {
				this.schemas.add(impt.getSchema2());
			} 
        }
    }
    
    public void addImport(Import impt){
    	imports.add(impt);
    	if(impt.getDescription() != null) {
            this.descriptions.add(impt.getDescription());
        } else if(impt.getSchema2() != null) {
            this.schemas.add(impt.getSchema2());
        }
    }
    
    public void removeImport(Import impt){
    	imports.remove(impt);
    	if(impt.getDescription() != null) {
            this.descriptions.remove(impt.getDescription());
        } else if(impt.getSchema2() != null) {
            this.schemas.remove(impt.getSchema2());
        }
    }
    
    public final String getProcessNamespace() {
        return processNamespace;
    }
    
    
    public static Description readDescription11(URL location) throws XmlObjectReadException {
        XmlObjectReader reader = xmlContext.createReader();
        return (org.petalslink.abslayer.service.api.Description) Factory.getInstance().wrap(reader.readDocument(location, Definitions.class));
    }

    public static Description readDescription20(URL location) {
        throw new UnsupportedOperationException();
    }
    
    public static com.ebmwebsourcing.easyschema10.api.element.Schema readSchema(URL location) throws SchemaException {
        XmlObjectReader reader = xmlContext.createReader();
        try {
            return reader.readDocument(location, com.ebmwebsourcing.easyschema10.api.element.Schema.class);
        } catch (XmlObjectReadException e) {
            throw new UncheckedException(e);
        }
    }
    
    
    public List<Import> getBPELImports() {
        return imports;
    }


    
    public final void addSchema(com.ebmwebsourcing.easyschema10.api.element.Schema schema) {
        synchronized(schemas) {
            schemas.add(schema);
        }
    }
    
    

    public PartnerLinkType getPartnerLinkType(QName plt) {
        for (Description desc : descriptions) {
            PartnerLinkType partnerLinkType = desc.getPartnerLinkType(plt);
            if (partnerLinkType != null) return partnerLinkType;
        }
        return null;
    }

    
    
    public Collection<Description> getDescriptions() {
        return Collections.unmodifiableCollection(descriptions);
        
    }
    
    
    public Description getDescriptionByService(QName service) {
        for (Description desc : descriptions) {
            if (desc.findInterface(service) != null) return desc;
        }
        return null;
    }

    public Description getDescriptionByInterface(QName itf) {
        for (Description desc : descriptions) {
            if (desc.findInterface(itf) != null) return desc;
        }
        return null;
    }

    public Description getDescriptionByProperty(QName propertyName) {
        throw new UnsupportedOperationException();
    }

    public List<Element> findElementsInAllSchema(
            QName element) {
        List<Element> elements = new ArrayList<Element>();
        for (Description desc : descriptions) {
            elements.addAll(desc.findElementsInAllSchema(element));
        }
        // ^^ BEURK : this should really not look in elements which are not top level elements!!
        // this should disappear naturally when XPath engine will be replaced.
        synchronized (schemas) {
            // FIXME: synchronisation on schemas should not be useful ; this is due to stuff which should be done at compile time
            // but which is done at runtime.
            for (com.ebmwebsourcing.easyschema10.api.element.Schema schema : schemas) {
                Element e = SchemaHelper.findElementByQName(schema, element);
                if (e != null) {
                    elements.add(e);    
                }
            }
        }
        return elements;
    }

    public List<Type> findTypesInAllSchema(
            QName type) {
        List<Type> types = new ArrayList<Type>();
        for (Description desc : descriptions) {
            Type t = SchemaHelper.findTypeByQName(desc.getModel(), type);
            if (t != null) {
                types.add(t);    
            }
        }
        // ^^ BEURK : this should really not look in elements which are not top level elements!!
        // this should disappear naturally when XPath engine will be replaced.
        synchronized (schemas) {
        for (com.ebmwebsourcing.easyschema10.api.element.Schema schema : schemas) {
            Type t = SchemaHelper.findTypeByQName(schema, type);
            if (t != null) {
                types.add(t);    
            }
        }
        }
        return types;
    }

    public Endpoint findEndpoint(String endpointName) {
        for (Description desc : descriptions) {
            Endpoint endpoint = desc.findEndpoint(endpointName);
            if (endpoint != null) return endpoint;
        }
        return null;
    }
    
    public Interface findInterface(final QName qname) {
        Interface itf = null; // interfaceCache.get(qname);
        // if (itf != null) return itf;
        for (Description desc : descriptions) {
            itf = desc.findInterface(qname);
            if (itf != null) {
                // interfaceCache.put(qname, itf);
                return itf;
            }
        }
        return null;
    }
    

    public Collection<Endpoint> findEndpointsImplementingInterface(final Interface itf) {
        assert itf != null;
        Set<Endpoint> endpoints = new HashSet<Endpoint>();
        for (Description desc : descriptions) {
            assert desc != null;
            endpoints.addAll(desc.findEndpointsImplementingInterface(itf));
        }
        return endpoints;
    }

    public Property getProperty(final QName qname) {
        for (Description desc : descriptions) {
            Property property = desc.findProperty(qname);
            if (property != null) return property;
        }
        return null;
    }

    
    public List<PropertyAlias> getPropertyAliases() {
        List<PropertyAlias> propertyAliases = new ArrayList<PropertyAlias>();
        for (Description desc : descriptions) {
            propertyAliases.addAll(desc.getPropertyAliases());
        }
        return propertyAliases;
    }

    
    public List<PropertyAlias> getPropertyAliases4ThisProperty(final QName propName) {
        List<PropertyAlias> propertyAliases = new ArrayList<PropertyAlias>();
        for (Description desc : descriptions) {
            propertyAliases.addAll(desc.getPropertyAliases4ThisProperty(propName));
        }
        return propertyAliases;
    }
    
    
    public Service findService(QName qname) {
        for (Description desc : descriptions) {
            Service s = desc.findService(qname);
            if (s != null) return s;
        }
        return null;
    }
    
    public NamespaceMapperImpl getNamespaces() {
        throw new UnsupportedOperationException();
    }
    
    public Message findMessage(QName qname) {
        Message message = null; // messageCache.get(qname);
        // if (message != null) return message;
        for (Description desc : descriptions) {
            message = desc.findMessage(qname);
            if (message != null) {
                // messageCache.put(qname, message);
                return message;
            }
        }
        return null;
    }
    
    public BindingOperation findBindingOperation(QName qname) {
        BindingOperation bindingOperation = null; 
        for (Description desc : descriptions) {
        	bindingOperation = desc.findBindingOperation(qname);
            if (bindingOperation != null) {
                return bindingOperation;
            }
        }
        return null;
    }    
    
    
    public WSDLVersionConstants getVersion() {
        throw new UnsupportedOperationException();
    }
    


    public List<Binding> getBindings() {
        List<Binding> bindings = new ArrayList<Binding>();
        for (Description desc : descriptions) {
            bindings.addAll(desc.getBindings());
        }
        return bindings;
        
    }
    
    public List<Service> getServices() {
        List<Service> services = new ArrayList<Service>();
        for (Description desc : descriptions) {
            services.addAll(desc.getServices());
        }
        return services;
        
    }
}
