/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractXMLElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;




/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public abstract class AbstractExtendedActivityImpl<E> extends AbstractXMLElementImpl<E> implements ExtendedActivity {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(AbstractExtendedActivityImpl.class.getName());

	protected JAXBContext jaxbContext;
	
	protected Sources sources = null;

	protected Targets targets = null;

	private QName tag = null;
	
	@SuppressWarnings("unchecked")
	public AbstractExtendedActivityImpl(final QName tag, final E model, final ExtensionActivity parent) throws BPELException {
		super(model, (AbstractXMLElementImpl) parent);
		this.tag = tag;
	}

	public AbstractExtendedActivityImpl(final QName tag, final Element elmt, final ExtensionActivity parent) throws BPELException {
		this.model = convertElementToModel(elmt);
		this.tag = tag;
		this.parent = (AbstractSchemaElementImpl) parent;
	}
	
	protected abstract E convertElementToModel(Element elmt) throws BPELException;
	
	public QName getTag() {
		return this.tag;
	}


	public void setTag(QName tag) {
		this.tag = tag;
	}


	public void addOtherElements(Element elmt) {
		throw new NotImplementedException();
	}


	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}


	public Sources getSources() {
		return this.sources;
	}

	public void setSources(Sources src) {
		this.sources = src;
	}


	public void setTargets(Targets trg) {
		this.targets = trg;
	}


	public Targets getTargets() {
		return this.targets;
	}

	public void validate() {
		com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.AbstractValidatorManagerImpl.getInstance().validate(this);
	}
	
	protected abstract void loadJaxbContext() throws BPELException, SchemaException;
	
	public JAXBContext getJaxbContext() throws BPELException, SchemaException {
		if(this.jaxbContext == null) {
			this.loadJaxbContext();
		}
		return this.jaxbContext;
	}
}
