/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.api;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;

/**
 * 
 * @author Nicolas Salatge - EBM WebSourcing
 * 
 */
public class BPELException extends CoreException {
    public static final long serialVersionUID = 1;

    private BindingMessageAdapter.Direction direction = BindingMessageAdapter.Direction.REQUEST;
    private boolean isBindingStyleRpc = false;
    
	public BPELException() {
		super();
	}
    
    public BPELException(final String msg, final Throwable t) {
        super(msg, t);
    }

    public BPELException(final Throwable t) {
        super(t);
    }

    public BPELException(final String msg) {
        super(msg);
    }
    
    
    public boolean getIsBindingStyleRpc() {
        return this.isBindingStyleRpc;
    }
    
    public void setIsBindingStyleRpc(boolean isBindingStyleRpc) {
        this.isBindingStyleRpc = isBindingStyleRpc;
    }

    
    public BindingMessageAdapter.Direction getDirection() {
        return this.direction;
    }
    
    public void setDirection(BindingMessageAdapter.Direction direction) {
        this.direction = direction;
    }
    
    
}
