/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.api.util;

import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;

public class ScopeUtil {

	public static PartnerLink findPartnerLinkRecursively(final String name, final BPELElement parent) {
		PartnerLink res = null;
		final Scope parentScope = ScopeUtil.getParentScope(parent);
		if(parentScope != null) {
			res  = parentScope.findPartnerLink(name);
		}
		if(res == null) {
			final BPELProcess process = ScopeUtil.getProcess(parent);
			res = process.findPartnerLink(name); 
		}
		return res;
	}


	public static BPELProcess getProcess(final SchemaElement parent) {
		BPELProcess res = null;
		if(parent != null) {
			if(parent instanceof BPELProcess) {
				res = (BPELProcess) parent;
			} else {
				res = ScopeUtil.getProcess((BPELElement) ((AbstractSchemaElementImpl)parent).getParent());
			}
		}
		return res;
	}





	public static Scope getParentScope(final BPELElement child) {
		Scope res = null;
		if(child != null) {
			final BPELElement parent = (BPELElement) ((AbstractSchemaElementImpl)child).getParent();
			if(parent != null) {
				if(parent instanceof Scope) {
					res = (Scope) parent;
				} else {
					res = ScopeUtil.getParentScope(parent);
				}
			}
		}
		return res;
	}

}
