/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.xpath.exp.api.verification;

import java.util.Date;

import javax.xml.namespace.QName;

import org.jdom.Element;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface TypeVerifier {

	Class<?> compare(Element e1, Element e2) throws XPathExpressionException;
	
	boolean isString(Element e) throws XPathExpressionException;
	
	boolean isInteger(Element e) throws XPathExpressionException;
	
	boolean isLong(Element e) throws XPathExpressionException;
	
	boolean isDouble(Element e) throws XPathExpressionException;
	
	boolean isBoolean(Element e) throws XPathExpressionException;
	
	boolean isDateTime(Element e) throws XPathExpressionException;
	
	int getIntValue(Element e);
	
	long getLongValue(Element e);
	
	double getDoubleValue(Element e);
	
	String getStringValue(Element e);
	
	boolean getBooleanValue(Element e);
	
	Date getDateTimeValue(Element e) throws XPathExpressionException;

	QName getQNameValue(Element e);
	
}
