/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELError;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELInfo;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELWarning;

public class ValidatorResultPrinter {

	private static ValidatorResultPrinter instance = new ValidatorResultPrinter();;

	public static ValidatorResultPrinter getInstance() {
		return instance;
	}

	public List<String> printErrorsAsString(final ValidatorResult v) {
		final List<String> res = new ArrayList<String>();
		for (final BPELError e : v.getErrors()) {
			res.add(e.getError().getMessage());
		}
		return res;
	}

	public String printAllErrors(final ValidatorResult v) {
		String res = "";
		for (final String s : this.printErrorsAsString(v)) {
			res = res + s + "\n";
		}
		return res;
	}

	public String printAllWarnings(final ValidatorResult v) {
		String res = "";
		for (final BPELWarning w : v.getWarnings()) {
			res = res + w.getWarning() + "\n";
		}
		return res;
	}

	public String printAllInfos(final ValidatorResult v) {
		String res = "";
		for (final BPELInfo i : v.getInfos()) {
			res = res + i.getInfo() + "\n";
		}
		return res;
	}

	public String printAll(final ValidatorResult v) {
		String res = "";
		if ((v.getInfos() != null) && (v.getInfos().size() > 0)) {
			res = res + v.getInfos().size() + " Infos:\n" + this.printAllInfos(v);
		}
		if (res.length() > 0) {
			res = res + "\n";
		}
		if ((v.getWarnings() != null) && (v.getWarnings().size() > 0)) {
			res = res + v.getWarnings().size() + " Warnings:\n"
			+ this.printAllWarnings(v);
		}
		if (res.length() > 0) {
			res = res + "\n";
		}
		if ((v.getErrors() != null) && (v.getErrors().size() > 0)) {
			res = res + v.getErrors().size() + " Errors:\n" + this.printAllErrors(v);
		}
		return res;
	}

	public String printAllXPathExpression(final ValidatorResult v) {
		String res = "";
		if ((v.getInfos() != null) && (v.getInfos().size() > 0)) {
			for (final XPathInfo i : v.getInfos()) {
				res = res + i.getXpathExpression() + "\n";
			}
		}

		if ((v.getWarnings() != null) && (v.getWarnings().size() > 0)) {
			for (final XPathWarning w : v.getWarnings()) {
				res = res + w.getXpathExpression() + "\n";
			}
		}

		if ((v.getErrors() != null) && (v.getErrors().size() > 0)) {
			for (final XPathError e : v.getErrors()) {
				res = res + e.getXpathExpression() + "\n";
			}
		}
		return res;
	}

}
