/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.AnalysorResult;
import java.net.URL;

public class BPELAnalyser {
    private static BPELReader reader = null;
    private static BPELException readerEx = null;

    public static BPELReader getBPELReader() throws BPELException {
        if (readerEx != null) {
            throw readerEx;
        }
        return reader;
    }

    public BPELAnalyser() throws BPELException {
        BPELAnalyser.getBPELReader();
    }

    public AnalysorResult analyze(URL bpel) throws BPELException {
        AnalysorResult res = null;
        if (bpel == null) {
            throw new BPELException("bpel uri cannot be null!!!");
        }
        BPELStaticAnalysisImpl.getInstance().getErrors().clear();
        BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
        BPELStaticAnalysisImpl.getInstance().getInfos().clear();
        BPELProcess process = null;
        process = BPELAnalyser.getBPELReader().readBPEL(URLUtil.urlToUri((URL)bpel));
        res = new AnalysorResult(process);
        return res;
    }

    public AnalysorResult analyze(BPELProcess process) throws BPELException {
        AnalysorResult res = null;
        if (process == null) {
            throw new BPELException("process cannot be null!!!");
        }
        BPELStaticAnalysisImpl.getInstance().getErrors().clear();
        BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
        BPELStaticAnalysisImpl.getInstance().getInfos().clear();
        res = new AnalysorResult(process);
        return res;
    }

    static {
        try {
            reader = BPELFactoryImpl.getInstance().newBPELReader();
        }
        catch (BPELException e) {
            readerEx = e;
        }
    }
}

