/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELInfo;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.util.XPathBuilder;

public class XPathInfo extends BPELInfoImpl {

	// private static Logger log = Logger.getLogger(XPathInfo.class.getName());

	private XPathExpr xpath = null;

	public XPathInfo(final BPELInfo f) {
		this(f.getElement(), f.getInfo());
	}

	public XPathInfo(final BPELElement elmt, final String f) {
		super(elmt, f);
		this.xpath = XPathBuilder.createXPathExpressionFromBPELElement(elmt);

	}

	public XPathExpr getXpathExpression() {
		return this.xpath;
	}

	public void setXPathExpression(final XPathExpr s) {
		this.xpath = s;
	}

}
