/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathError;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathInfo;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathWarning;
import java.util.ArrayList;
import java.util.List;

public class ValidatorResultPrinter {
    private static ValidatorResultPrinter instance = new ValidatorResultPrinter();

    public static ValidatorResultPrinter getInstance() {
        return instance;
    }

    public List<String> printErrorsAsString(ValidatorResult v) {
        ArrayList<String> res = new ArrayList<String>();
        for (XPathError e : v.getErrors()) {
            res.add(e.getError().getMessage());
        }
        return res;
    }

    public String printAllErrors(ValidatorResult v) {
        String res = "";
        for (String s : this.printErrorsAsString(v)) {
            res = res + s + "\n";
        }
        return res;
    }

    public String printAllWarnings(ValidatorResult v) {
        String res = "";
        for (XPathWarning w : v.getWarnings()) {
            res = res + w.getWarning() + "\n";
        }
        return res;
    }

    public String printAllInfos(ValidatorResult v) {
        String res = "";
        for (XPathInfo i : v.getInfos()) {
            res = res + i.getInfo() + "\n";
        }
        return res;
    }

    public String printAll(ValidatorResult v) {
        String res = "";
        if (v.getInfos() != null && v.getInfos().size() > 0) {
            res = res + v.getInfos().size() + " Infos:\n" + this.printAllInfos(v);
        }
        if (res.length() > 0) {
            res = res + "\n";
        }
        if (v.getWarnings() != null && v.getWarnings().size() > 0) {
            res = res + v.getWarnings().size() + " Warnings:\n" + this.printAllWarnings(v);
        }
        if (res.length() > 0) {
            res = res + "\n";
        }
        if (v.getErrors() != null && v.getErrors().size() > 0) {
            res = res + v.getErrors().size() + " Errors:\n" + this.printAllErrors(v);
        }
        return res;
    }

    public String printAllXPathExpression(ValidatorResult v) {
        String res = "";
        if (v.getInfos() != null && v.getInfos().size() > 0) {
            for (XPathInfo i : v.getInfos()) {
                res = res + i.getXpathExpression() + "\n";
            }
        }
        if (v.getWarnings() != null && v.getWarnings().size() > 0) {
            for (XPathWarning w : v.getWarnings()) {
                res = res + w.getXpathExpression() + "\n";
            }
        }
        if (v.getErrors() != null && v.getErrors().size() > 0) {
            for (XPathError e : v.getErrors()) {
                res = res + e.getXpathExpression() + "\n";
            }
        }
        return res;
    }
}

