/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;

public class ValidatorResult {

	private List<XPathError> errors = new ArrayList<XPathError>();

	private List<XPathWarning> warnings = new ArrayList<XPathWarning>();

	private List<XPathInfo> infos = new ArrayList<XPathInfo>();
	
	private BPELProcess process = null;
	
	
	public ValidatorResult(BPELProcess process) {
		this.process = process;
	}
	

	public BPELProcess getProcess() {
		return process;
	}


	public void addError(final XPathError e) {
		this.errors.add(e);
	}

	public List<XPathError> getErrors() {
		return this.errors;
	}

	public void addWarning(final XPathWarning warn) {
		this.warnings.add(warn);
	}

	public List<XPathWarning> getWarnings() {
		return this.warnings;
	}

	public void addInfos(final XPathInfo info) {
		this.infos.add(info);
	}

	public List<XPathInfo> getInfos() {
		return this.infos;
	}

}
