/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;

import org.apache.commons.lang.NotImplementedException;
import org.jdom.Element;
import org.ow2.easywsdl.schema.api.XMLElement;
import org.ow2.easywsdl.schema.api.XmlException;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELElementExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELElementExpressionImpl extends BPELExpressionImpl<Element> implements BPELElementExpression {

	
	private final Logger log = Logger.getLogger(BPELElementExpressionImpl.class.getName());

	
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	
	private final BPELProcess bpeldefinition;


	public BPELElementExpressionImpl(final TExpression model, final XMLElement parent, BPELProcess bpeldefinition) throws XPathExpressionException {
		super(model, parent);
		this.bpeldefinition = bpeldefinition;
	}

	public Element evaluate(final Scope scope) throws CoreException {
		Element res = null;
		String elmtExpression = "";
		if(this.getContent() != null) {
			elmtExpression = this.getContent();
		}
		try {
			this.log.finest("element expression to evaluate: " + elmtExpression);
//			final InputStream input = new ByteArrayInputStream(s.getBytes());
			final ExpressionAnalyzer analyzer = new ExpressionAnalyzer(elmtExpression);
			final ASTStart n = analyzer.Start();
			final ExpressionVisitor v = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
			if(!this.log.getName().equals(BPELElementExpressionImpl.class.getName())) {
				((ExpressionDumpVisitor)v).setLog(this.log);
			}
			final Object result = n.jjtAccept(v, null);
			if(result instanceof BPELException) {
				throw (BPELException)result;
			} else if(result instanceof org.jdom.Element) {
				res = (org.jdom.Element)result; 
			} else {
				throw new BPELException("result unknown");
			}
		} catch (final ParseException e) {
			throw new CoreException("Impossible to evaluate expression: " + elmtExpression, e);
		}
		return res;
	}

	public Expression<String, Element> copypaste() {
		BPELElementExpression exp = null;
		try {
			exp = new BPELElementExpressionImpl(this.getModel(), (XMLElement) this.getParent(), this.bpeldefinition);
		} catch (XPathExpressionException e) {
			// do nothing
		}
		return exp;
	}

	public void addOtherElements(org.w3c.dom.Element elmt) {
		throw new NotImplementedException();
	}

	public List<org.w3c.dom.Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}



}
