/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.util;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.VariablePart;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;

public class ExpressionUtil {
    public static String convertVariable2Expression(VariablePart var) throws XPathExpressionException {
        String expression = null;
        if (var != null) {
            expression = "$" + var.getVariable();
            if (var.getPart() != null) {
                expression = expression + "." + var.getPart();
            }
            if (var.getQuery() != null) {
                if (!var.getQuery().getQueryLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")) {
                    throw new XPathExpressionException("this query language (" + var.getQuery().getQueryLanguage() + ") is not recognized. Only XPATH1.0 language (urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0) is supported");
                }
                expression = var.getQuery().getContent().startsWith("/") ? expression + var.getQuery().getContent().trim() : expression + "/" + var.getQuery().getContent().trim();
            }
        }
        return expression.trim();
    }

    public static List<String> createXPathExpressionByReplacingPartByElement(String partName, BPELVariable variable, String xpathExpression, BPELProcess bpelDefinition) throws XPathExpressionException {
        ArrayList<String> xpathExpressions = new ArrayList<String>();
        String expWithoutVarAndPart = null;
        if (xpathExpression.indexOf("/") > 0) {
            expWithoutVarAndPart = xpathExpression.substring(xpathExpression.indexOf("/"));
        }
        if (expWithoutVarAndPart == null && partName == null) {
            xpathExpression = "/";
            xpathExpressions.add(xpathExpression);
        } else if (variable.getMessageType() != null) {
            Message msg = bpelDefinition.getImports().findMessage(variable.getMessageType());
            if (msg == null) {
                throw new XPathExpressionException("BPELError: the message cannot be null: " + variable.getMessageType());
            }
            QName partQName = new QName(variable.getMessageType().getNamespaceURI(), partName);
            Part part = msg.getPart(partQName);
            if (part == null) {
                throw new XPathExpressionException("Impossible to find part corresponding to " + partName);
            }
            if (part.getElement() != null) {
                String namespaceURI = part.getElement().inferQName().getNamespaceURI();
                String prefix = bpelDefinition.getNamespaceContext().getPrefix(namespaceURI);
                if (prefix == null && (prefix = bpelDefinition.getImports().getNamespaces().getPrefix(namespaceURI)) != null) {
                    if (bpelDefinition.getNamespaceContext().getNamespaceURI(prefix) == null) {
                        bpelDefinition.getNamespaceContext().addNamespace(prefix, namespaceURI);
                    } else {
                        int i = 0;
                        String nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
                        while (nsAlreadyExist != null) {
                            nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + ++i);
                        }
                        prefix = "cns" + i;
                        bpelDefinition.getNamespaceContext().addNamespace(prefix, namespaceURI);
                    }
                }
                String localName = part.getElement().getName();
                if (expWithoutVarAndPart == null) {
                    expWithoutVarAndPart = "";
                }
                if (prefix != null) {
                    String validRpcXpathExpression = prefix + ":" + localName + expWithoutVarAndPart;
                    xpathExpressions.add(validRpcXpathExpression);
                }
                String degradedRpcXpathExpression = localName + expWithoutVarAndPart;
                xpathExpressions.add(degradedRpcXpathExpression);
                if (prefix != null) {
                    String validDocXpathExpression = "/" + prefix + ":" + localName + expWithoutVarAndPart;
                    xpathExpressions.add(validDocXpathExpression);
                }
                String degradedDocXpathExpression = "/" + localName + expWithoutVarAndPart;
                xpathExpressions.add(degradedDocXpathExpression);
            } else if (part.getQName() != null) {
                String prefix = bpelDefinition.getNamespaceContext().getPrefix(part.getQName().getNamespaceURI());
                if (prefix == null && (prefix = bpelDefinition.getImports().getNamespaces().getPrefix(part.getType().getNamespaceURI())) != null) {
                    if (bpelDefinition.getNamespaceContext().getNamespaceURI(prefix) == null) {
                        bpelDefinition.getNamespaceContext().addNamespace(prefix, part.getType().getNamespaceURI());
                    } else {
                        int i = 0;
                        String nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
                        while (nsAlreadyExist != null) {
                            nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + ++i);
                        }
                        prefix = "cns" + i;
                        bpelDefinition.getNamespaceContext().addNamespace(prefix, part.getType().getNamespaceURI());
                    }
                }
                String localName = part.getQName().getLocalPart();
                if (expWithoutVarAndPart == null) {
                    expWithoutVarAndPart = "";
                }
                if (prefix != null) {
                    String validRpcXpathExpression = prefix + ":" + localName + expWithoutVarAndPart;
                    xpathExpressions.add(validRpcXpathExpression);
                }
                String degradedRpcXpathExpression = localName + expWithoutVarAndPart;
                xpathExpressions.add(degradedRpcXpathExpression);
                if (prefix != null) {
                    String validDocXpathExpression = "/" + prefix + ":" + localName + expWithoutVarAndPart;
                    xpathExpressions.add(validDocXpathExpression);
                }
                String degradedDocXpathExpression = "/" + localName + expWithoutVarAndPart;
                xpathExpressions.add(degradedDocXpathExpression);
            }
        } else if (variable.getTypeQName() != null) {
            xpathExpression = xpathExpression.replace("$", "/");
            xpathExpressions.add(xpathExpression);
            xpathExpression = xpathExpression.replaceFirst("/", "/" + variable.getTypeQName().getPrefix() + ":");
            xpathExpressions.add(xpathExpression);
        } else if (variable.getElement() != null) {
            if (expWithoutVarAndPart == null) {
                expWithoutVarAndPart = "";
            }
            xpathExpression = variable.getElement().getLocalPart() + expWithoutVarAndPart;
            xpathExpressions.add(xpathExpression);
            if (expWithoutVarAndPart.trim().length() > 0) {
                xpathExpression = expWithoutVarAndPart.replaceFirst("/", "");
                xpathExpressions.add(xpathExpression);
            }
            if (variable.getElement().getPrefix() != null) {
                xpathExpression = variable.getElement().getPrefix() + ":" + variable.getElement().getLocalPart() + expWithoutVarAndPart;
            }
            xpathExpressions.add(xpathExpression);
        }
        return xpathExpressions;
    }
}

