/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.StartWithFunction;

/**
 * @author Julien Lesbegueries - eBM WebSourcing
 */
public class StartWithFunctionImpl extends AbstractXPathFunction<Boolean>  implements StartWithFunction {

	private static Logger log = Logger
			.getLogger(StartWithFunctionImpl.class.getName());

	private final String _oriString;
	private final String prefix;

	public StartWithFunctionImpl(final String ns, final String oriString, final String prefix) throws XPathExpressionException {
		super(ns);
		this._oriString = oriString;
		this.prefix = prefix;
		log.finest("Parameters for start-with function: "+oriString+" "+prefix);
	}

	

	
	public Boolean process() throws XPathExpressionException {
		final boolean res = this._oriString.startsWith(prefix);
		log.finest("Result of start-with function: "+res);
		return res;
	}
	
}
