/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDeadlineExpr;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELDeadLineExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;


public class BPELDeadLineExpressionImpl extends BPELElementImpl<TDeadlineExpr> implements BPELDeadLineExpression  {



	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Logger log = Logger.getLogger(BPELDeadLineExpressionImpl.class.getName());

	private final BPELProcess bpeldefinition;


	public BPELDeadLineExpressionImpl(final TDeadlineExpr model,
			final BPELElement parent) {
		super(Constants._Until_QNAME, model, parent);
		this.bpeldefinition = ScopeUtil.getProcess(parent);
	}
	
	public URI getExpressionLanguage() {
		final URI res = null;
		if((this.model != null) && (this.model.getExpressionLanguage() != null)) {
			URI.create(this.model.getExpressionLanguage());
		}
		return res;
	}

	public void setExpressionLanguage(final URI language) {
		this.model.setExpressionLanguage(language.toString());
	}

	public String getContent() {
		String content = null;
		if((this.model.getContent() != null) && (this.model.getContent().size() > 0)) {
			content = this.model.getContent().get(0).toString();
		}
		return content;
	}

	public void setContent(final String arg0) {
		if(this.model != null) {
			this.model.getContent().clear();
			this.model.getContent().add(arg0);
		}
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	public Date evaluate(final Scope scope) throws CoreException {
		Date res = null;
		String dateExpression = "";
		if(this.getContent() != null) {
			dateExpression = this.getContent();
			dateExpression = this.getContent().replace("'", "\"");
		}
		try {
			this.log.finest("date expression to evaluate: " + dateExpression);
//			final InputStream input = new ByteArrayInputStream(dateExpression.getBytes());
			final ExpressionAnalyzer analyzer = new ExpressionAnalyzer(dateExpression);
			final ASTStart n = analyzer.Start();
			final ExpressionVisitor v = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
			if(!this.log.getName().equals(BPELDeadLineExpressionImpl.class.getName())) {
				((ExpressionDumpVisitor)v).setLog(this.log);
			}
			final Object result = n.jjtAccept(v, null);
			if(result instanceof BPELException) {
				throw (BPELException)result;
			} else if(result instanceof org.jdom.Element) {
				final org.jdom.Element elmt = (org.jdom.Element)result; 
				dateExpression = elmt.getText().replace("'", "");
				dateExpression = elmt.getText().replace("\"", "");
				res = DatatypeFactory.newInstance().newXMLGregorianCalendar(elmt.getText()).toGregorianCalendar().getTime();
			} else {
				throw new BPELException("result unknown");
			}
		} catch (final BPELException e) {
			throw new CoreException("Impossible to evaluate expression: " + dateExpression, e);
		} catch (final ParseException e) {
			throw new CoreException("Impossible to evaluate expression: " + dateExpression, e);
		} catch (final DatatypeConfigurationException e) {
			throw new CoreException("Impossible to evaluate expression: " + dateExpression, e);
		}
		return res;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public Expression<String, Date> copypaste() {
		final BPELDeadLineExpression exp = new BPELDeadLineExpressionImpl(this.getModel(), (BPELElement) this.getParent());
		return exp;
	}


}
