/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.net.URI;

import org.ow2.easywsdl.schema.api.XMLElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractXMLElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class BPELExpressionImpl<E> extends AbstractXMLElementImpl<TExpression> implements BPELExpression<E> {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;


	public BPELExpressionImpl(final TExpression model, final XMLElement parent) throws XPathExpressionException {
		super(model, (AbstractXMLElementImpl) parent);
		
		// validation on content
		if((this.getExpressionLanguage() != null) && !this.getExpressionLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")
				&& !this.getExpressionLanguage().toString().equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
			throw new XPathExpressionException("In expressionLanguage => Unknowned uri: " + this.getExpressionLanguage() + ". Only the uri " + "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0" + " and " + "http://www.w3.org/TR/1999/REC-xpath-19991116"+ " are supported");
		}
	}

	public String getContent() {
		String def = null;
		if((this.model != null) && (this.model.getContent() != null) && (this.model.getContent().size() > 0)) {
			def = (String) this.model.getContent().get(0);
			for(final Object s: this.model.getContent()) {
				if((s != null) && (s.toString().trim().length() > 0)) {
					def = (String) s;
				}
			}
		}
		return def;
	}

	public void setContent(final String content) {
		if(this.model != null) {
			this.model.getContent().clear();
			this.model.getContent().add(content);
		}
	}

	public URI getExpressionLanguage() {
		URI res = null;
		if((this.model != null) && (this.model.getExpressionLanguage() != null)) {
			res = URI.create(this.model.getExpressionLanguage());
		}
		return res;
	}

	public void setExpressionLanguage(final URI language) {
		this.model.setExpressionLanguage(language.toString());
	}


}
